/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.validator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;

public class ObjectModelValidator {
    protected ObjectModel model;
    private List<String> errors;

    public ObjectModelValidator(ObjectModel model) {
        this.model = model;
        this.errors = new ArrayList<String>();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean validate() {
        if (this.errors.size() > 0) {
            this.errors = new ArrayList<String>();
        }
        boolean isValid = this.validateModel(this.model);
        for (ObjectModelClassifier classifier : this.model.getClassifiers()) {
            isValid &= this.validateClassifier(classifier);
            if (classifier instanceof ObjectModelInterface) {
                isValid &= this.validateInterface((ObjectModelInterface)classifier);
            }
            if (classifier instanceof ObjectModelClass) {
                ObjectModelClass clazz = (ObjectModelClass)classifier;
                isValid &= this.validateClass(clazz);
                for (ObjectModelAttribute objectModelAttribute : clazz.getAttributes()) {
                    isValid &= this.validateAttribute(objectModelAttribute);
                }
            }
            for (ObjectModelOperation objectModelOperation : classifier.getOperations()) {
                isValid &= this.validateOperation(objectModelOperation);
            }
        }
        return isValid;
    }

    protected boolean validateModel(ObjectModel model) {
        String modelName = model.getName();
        if (StringUtils.isBlank((CharSequence)modelName)) {
            this.addError(model, "model has no name");
        }
        return true;
    }

    protected boolean validateClassifier(ObjectModelClassifier classifier) {
        return true;
    }

    protected boolean validateInterface(ObjectModelInterface interfacezz) {
        return true;
    }

    protected boolean validateClass(ObjectModelClass clazz) {
        return true;
    }

    protected boolean validateAttribute(ObjectModelAttribute attr) {
        return true;
    }

    protected boolean validateOperation(ObjectModelOperation operation) {
        return true;
    }

    protected void addError(Object onElement, String reason) {
        Object elementString = onElement.toString();
        if (onElement instanceof ObjectModelAttribute) {
            ObjectModelAttribute attribute = (ObjectModelAttribute)onElement;
            elementString = ((ObjectModelClassifier)attribute.getDeclaringElement()).getQualifiedName() + "#" + attribute.getName();
        } else if (onElement instanceof ObjectModelClassifier) {
            ObjectModelClassifier classifier = (ObjectModelClassifier)onElement;
            elementString = classifier.getQualifiedName();
        }
        this.errors.add("[" + (String)elementString + "] " + reason);
    }
}

