/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.reader;

import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.ModelHelper;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.reader.AbstractObjectModelReader;
import org.nuiton.eugene.models.object.reader.yaml.LoadYamlFile;
import org.yaml.snakeyaml.error.YAMLException;

@Component(role=ModelReader.class, hint="yamlobjectmodel")
public class YamlObjectModelReader
extends AbstractObjectModelReader {
    private static final Logger log = LogManager.getLogger(YamlObjectModelReader.class);
    protected LoadYamlFile loaderYAML;

    @Override
    public String getInputType() {
        return ModelHelper.ModelInputType.YAML.getAlias();
    }

    @Override
    protected void beforeReadFile(File ... files) {
        super.beforeReadFile(files);
        this.loaderYAML = new LoadYamlFile();
    }

    @Override
    protected void readFileToModel(File file, ObjectModel model) throws IOException {
        try {
            this.loaderYAML.loadFile(file, model);
        }
        catch (YAMLException e) {
            throw new IOException("Unable to parse ObjectModel input file : " + file, e);
        }
    }
}

