/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.ModelHelper;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.models.friend.ModelDef;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.reader.AbstractObjectModelReader;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;

@Component(role=ModelReader.class, hint="friendobjectmodel")
public class FriendObjectModelReader
extends AbstractObjectModelReader {
    private static final Logger log = LogManager.getLogger(FriendObjectModelReader.class);

    @Override
    public String getInputType() {
        return ModelHelper.ModelInputType.FRIEND.getAlias();
    }

    @Override
    protected void beforeReadFile(File ... files) {
        super.beforeReadFile(files);
    }

    @Override
    protected void readFileToModel(File file, ObjectModel model) throws IOException {
        log.info("Read file: " + file);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            ModelDef modelDef = ModelDef.of(model, reader);
            modelDef.toObjectModel((ObjectModelImpl)model);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse input file : " + file, e);
        }
    }
}

