/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.reader;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.nuiton.eugene.ModelHelper;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.models.extension.io.ModelExtensionReader;
import org.nuiton.eugene.models.extension.tagvalue.InvalidStereotypeSyntaxException;
import org.nuiton.eugene.models.extension.tagvalue.InvalidTagValueSyntaxException;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelPackageImpl;

public abstract class AbstractObjectModelReader
extends ModelReader<ObjectModel> {
    private static final Logger log = LogManager.getLogger(AbstractObjectModelReader.class);

    @Override
    public String getModelType() {
        return ModelHelper.ModelType.OBJECT.getAlias();
    }

    protected abstract void readFileToModel(File var1, ObjectModel var2) throws IOException;

    protected void beforeReadFile(File ... files) {
    }

    @Override
    public ObjectModel read(File ... files) throws IOException {
        this.beforeReadFile(files);
        ObjectModelImpl model = new ObjectModelImpl();
        ModelExtensionReader modelExtensionReader = new ModelExtensionReader(this.isVerbose(), this.strictLoading, model);
        for (File file : files) {
            this.readFileToModel(file, model);
            this.addAllSubPackages(model);
            File dir = file.getParentFile();
            String ext = FileUtils.extension((String)file.getName());
            String name = FileUtils.basename((String)file.getName(), (String)("." + ext));
            File propFile = new File(dir, name + ".properties");
            if (!propFile.exists()) {
                if (!this.isVerbose()) continue;
                log.info("Pas de fichier de propri\u00e9t\u00e9s " + propFile + " associ\u00e9 au model");
                continue;
            }
            if (this.isVerbose()) {
                log.info("Lecture du fichier de propri\u00e9t\u00e9s " + propFile + " associ\u00e9 au model");
            }
            try {
                modelExtensionReader.read(propFile);
            }
            catch (InvalidStereotypeSyntaxException | InvalidTagValueSyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        if (log.isDebugEnabled()) {
            for (ObjectModelClass m : model.getClasses()) {
                log.debug("loaded class in model: " + m.getName());
            }
        }
        return model;
    }

    protected void addAllSubPackages(ObjectModelImpl model) {
        LinkedHashSet<String> subPackageNames = new LinkedHashSet<String>();
        for (ObjectModelPackage aPackage : Sets.newHashSet(model.getPackages())) {
            String aPackageName = aPackage.getName();
            if (this.verbose) {
                log.info("Treat package: " + aPackageName);
            }
            if (!subPackageNames.add(aPackageName)) continue;
            this.addSubPackages(model, aPackageName);
        }
    }

    protected void addSubPackages(ObjectModelImpl model, String aPackageName) {
        Object subPackageName = null;
        ObjectModelPackageImpl parentPackage = null;
        for (String part : aPackageName.split("\\.")) {
            ObjectModelPackageImpl subPackage = (ObjectModelPackageImpl)model.getPackage((String)(subPackageName = subPackageName == null ? part : (String)subPackageName + "." + part));
            if (subPackage == null) {
                subPackage = new ObjectModelPackageImpl();
                subPackage.setName((String)subPackageName);
                model.addPackage(subPackage);
                if (this.verbose) {
                    log.info("Add sub package: " + (String)subPackageName);
                }
            }
            if (subPackage.getParentPackage() == null && parentPackage != null) {
                if (this.verbose) {
                    log.info("Set parent package " + parentPackage.getName() + " to " + part);
                }
                subPackage.setParentPackage(parentPackage);
            }
            parentPackage = subPackage;
        }
    }
}

