/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.nuiton.eugene.models.object.ObjectModelModifier;

public enum ObjectModelJavaModifier implements ObjectModelModifier
{
    STATIC,
    FINAL,
    ABSTRACT,
    TRANSIENT,
    PUBLIC,
    PROTECTED,
    PRIVATE,
    PACKAGE,
    DEFAULT,
    VOLATILE,
    SYNCHRONIZED,
    NATIVE,
    STRICTFP;

    public static final Set<? extends ObjectModelModifier> visibilityModifiers;

    @Override
    public boolean isVisibility() {
        return visibilityModifiers.contains(this);
    }

    @Override
    public boolean isAssociationType() {
        return false;
    }

    @Override
    public String getName() {
        return this.name();
    }

    public String toString() {
        String result = this.name().toLowerCase();
        if (PACKAGE.equals(this)) {
            result = "";
        }
        return result;
    }

    public static ObjectModelJavaModifier fromVisibility(String name) {
        if (name.equals(PUBLIC.toString())) {
            return PUBLIC;
        }
        if (name.equals(PRIVATE.toString())) {
            return PRIVATE;
        }
        if (name.equals(PROTECTED.toString())) {
            return PROTECTED;
        }
        if (name.equals(PACKAGE.toString())) {
            return PACKAGE;
        }
        return null;
    }

    static {
        visibilityModifiers = ImmutableSet.of((Object)PUBLIC, (Object)PROTECTED, (Object)PRIVATE, (Object)PACKAGE);
    }
}

