/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.AbstractGenerator;
import org.nuiton.eugene.MonitorWriter;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelType;

public class ObjectModelGenerator
extends AbstractGenerator<ObjectModel> {
    private static Logger log = LogManager.getLogger(ObjectModelGenerator.class);

    public ObjectModelGenerator() {
    }

    public ObjectModelGenerator(AbstractGenerator<ObjectModel> parent) {
        super(parent);
    }

    @Override
    public void applyTemplate(ObjectModel model, File destDir) throws IOException {
        if (StringUtils.isEmpty((CharSequence)model.getName())) {
            throw new IllegalArgumentException("No name defined on the model");
        }
        this.model = model;
        String filename = this.getFilenameForModel(model);
        this.generateFromElement(model, destDir, filename, ObjectModelType.OBJECT_MODEL);
        this.generateFromElements(model.getClassifiers(), destDir, ObjectModelType.OBJECT_MODEL_CLASSIFIER);
        this.generateFromElements(model.getInterfaces(), destDir, ObjectModelType.OBJECT_MODEL_INTERFACE);
        this.generateFromElements(model.getClasses(), destDir, ObjectModelType.OBJECT_MODEL_CLASS);
        this.generateFromElements(model.getEnumerations(), destDir, ObjectModelType.OBJECT_MODEL_ENUMERATION);
    }

    private void generateFromElements(Collection<? extends ObjectModelElement> elements, File destDir, ObjectModelType type) {
        for (ObjectModelElement objectModelElement : elements) {
            String filename = "";
            switch (type) {
                case OBJECT_MODEL_CLASSIFIER: {
                    filename = this.getFilenameForClassifier((ObjectModelClassifier)objectModelElement);
                    break;
                }
                case OBJECT_MODEL_INTERFACE: {
                    filename = this.getFilenameForInterface((ObjectModelInterface)objectModelElement);
                    break;
                }
                case OBJECT_MODEL_CLASS: {
                    filename = this.getFilenameForClass((ObjectModelClass)objectModelElement);
                    break;
                }
                case OBJECT_MODEL_ENUMERATION: {
                    filename = this.getFilenameForEnumeration((ObjectModelEnumeration)objectModelElement);
                }
            }
            this.generateFromElement(objectModelElement, destDir, filename, type);
        }
    }

    protected void generateFromElement(Object element, File destDir, String filename, ObjectModelType type) {
        if (this.canGenerateElement(element)) {
            File outputFile = this.getDestinationFile(destDir, filename);
            if (!this.isOverwrite() && this.isNewerThanSource(outputFile)) {
                if (this.isVerbose() && log.isInfoEnabled()) {
                    log.info("Will not generate " + outputFile + " (up-to-date).");
                }
                return;
            }
            if (!outputFile.exists() && log.isDebugEnabled()) {
                log.debug("not up-to-date " + outputFile.lastModified() + " <" + outputFile + ">");
            }
            try {
                StringWriter out = new StringWriter();
                try (MonitorWriter monitorOut = new MonitorWriter(out);){
                    switch (type) {
                        case OBJECT_MODEL: {
                            this.generateFromModel(monitorOut, (ObjectModel)element);
                            break;
                        }
                        case OBJECT_MODEL_CLASSIFIER: {
                            this.generateFromClassifier(monitorOut, (ObjectModelClassifier)element);
                            break;
                        }
                        case OBJECT_MODEL_INTERFACE: {
                            this.generateFromInterface(monitorOut, (ObjectModelInterface)element);
                            break;
                        }
                        case OBJECT_MODEL_CLASS: {
                            this.generateFromClass(monitorOut, (ObjectModelClass)element);
                            break;
                        }
                        case OBJECT_MODEL_ENUMERATION: {
                            this.generateFromEnumeration(monitorOut, (ObjectModelEnumeration)element);
                        }
                    }
                    this.write(outputFile, monitorOut);
                }
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn("Erreur lors de la g\u00e9n\u00e9ration du fichier " + outputFile);
                }
                throw new RuntimeException("Erreur lors de la g\u00e9n\u00e9ration du fichier " + outputFile, eee);
            }
        }
    }

    protected boolean canGenerateElement(Object element) {
        boolean canGenerate = true;
        if (element instanceof ObjectModelClassifier) {
            ObjectModelClassifier classifier = (ObjectModelClassifier)element;
            String classifierPackage = classifier.getPackageName();
            canGenerate = this.canGeneratePackage(classifierPackage);
        }
        return canGenerate;
    }

    public String getFilenameForModel(ObjectModel model) {
        return model.getName();
    }

    public String getFilenameForPackage(ObjectModel model, String packageName) {
        return packageName.replace('.', File.separatorChar);
    }

    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return this.getFilenameForClassifier(interfacez);
    }

    public String getFilenameForClass(ObjectModelClass clazz) {
        return this.getFilenameForClassifier(clazz);
    }

    public String getFilenameForClassifier(ObjectModelClassifier classifier) {
        return classifier.getQualifiedName().replace('.', File.separatorChar);
    }

    public String getFilenameForEnumeration(ObjectModelEnumeration enumeration) {
        return this.getFilenameForClassifier(enumeration);
    }

    public void generateFromModel(Writer output, ObjectModel input) throws IOException {
    }

    public void generateFromInterface(Writer output, ObjectModelInterface input) throws IOException {
    }

    public void generateFromEnum(Writer output, ObjectModelEnumeration input) throws IOException {
    }

    public void generateFromClass(Writer output, ObjectModelClass input) throws IOException {
    }

    public void generateFromClassifier(Writer output, ObjectModelClassifier input) throws IOException {
    }

    public void generateFromEnumeration(Writer output, ObjectModelEnumeration input) throws IOException {
    }
}

