/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.ObjectModelType;
import org.nuiton.eugene.models.object.xml.ObjectModeImplAssociationClassParticipant;
import org.nuiton.eugene.models.object.xml.ObjectModelAssociationClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassifierImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelElementImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelEnumerationImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelImplSuperClassRef;
import org.nuiton.eugene.models.object.xml.ObjectModelImplTagValue;
import org.nuiton.eugene.models.object.xml.ObjectModelInterfaceImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelOperationImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelParameterImpl;

public class ObjectModelBuilder {
    private static final Logger log = LogManager.getLogger(ObjectModelBuilder.class);
    protected ObjectModelImpl model = new ObjectModelImpl();

    public ObjectModelBuilder(String name) {
        this.model.setName(name);
    }

    public ObjectModel getModel() {
        return this.model;
    }

    public void addTagValue(String name, String value) {
        ObjectModelImplTagValue tagValue = new ObjectModelImplTagValue();
        tagValue.setName(name);
        tagValue.setValue(value);
        this.model.addTagValue(tagValue);
    }

    public void addTagValue(ObjectModelElement element, String name, String value) {
        ObjectModelElementImpl impl = (ObjectModelElementImpl)element;
        ObjectModelImplTagValue tagValue = new ObjectModelImplTagValue();
        tagValue.setName(name);
        tagValue.setValue(value);
        impl.addTagValue(tagValue);
    }

    public ObjectModelClass createClass(String name, String packageName, ObjectModelModifier ... modifiers) {
        ObjectModelClassImpl result = new ObjectModelClassImpl();
        return this.createClass(result, name, packageName, modifiers);
    }

    protected ObjectModelClass createClass(ObjectModelClassImpl clazz, String name, String packageName, ObjectModelModifier ... modifiers) throws IllegalArgumentException {
        clazz.setName(name);
        clazz.setPackage(packageName);
        this.setClassModifiers(clazz, modifiers);
        this.model.addClass(clazz);
        return clazz;
    }

    protected void setClassModifiers(ObjectModelClassImpl clazz, ObjectModelModifier ... modifiers) throws IllegalArgumentException {
        clazz.addModifier(modifiers);
    }

    public ObjectModelInterface createInterface(String name, String packageName) {
        ObjectModelInterfaceImpl result = new ObjectModelInterfaceImpl();
        result.setName(name);
        result.setPackage(packageName);
        this.model.addInterface(result);
        return result;
    }

    public ObjectModelEnumeration createEnumeration(String name, String packageName) {
        ObjectModelEnumerationImpl result = new ObjectModelEnumerationImpl();
        result.setName(name);
        result.setPackage(packageName);
        this.model.addEnumeration(result);
        return result;
    }

    public ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, String name, String type) {
        return this.addAttribute(classifier, name, type, "", new ObjectModelModifier[0]);
    }

    public ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, String name, String type, String value, ObjectModelModifier ... modifiers) throws IllegalArgumentException {
        ObjectModelAttributeImpl attribute = new ObjectModelAttributeImpl();
        attribute.setName(name);
        attribute.setType(type);
        attribute.setDefaultValue(value);
        attribute.addModifier(modifiers);
        ObjectModelClassifierImpl classifierImpl = (ObjectModelClassifierImpl)classifier;
        classifierImpl.addAttribute(attribute);
        return attribute;
    }

    public ObjectModelAttribute addAssociation(ObjectModelClassifier classifierA, ObjectModelClassifier classifierB, String roleName, int minMultiplicity, int maxMultiplicity, ObjectModelModifier ... modifiers) throws IllegalArgumentException {
        ObjectModelAttributeImpl attribute = new ObjectModelAttributeImpl();
        attribute.setName(roleName);
        attribute.setMinMultiplicity(minMultiplicity);
        attribute.setMaxMultiplicity(maxMultiplicity);
        attribute.setType(classifierB.getQualifiedName());
        attribute.addModifier(modifiers);
        ObjectModelClassifierImpl impl = (ObjectModelClassifierImpl)classifierA;
        impl.addAttribute(attribute);
        return attribute;
    }

    public ObjectModelAttribute addReverseAssociation(ObjectModelAttribute attrAssociation, String roleName, int minMultiplicity, int maxMultiplicity, ObjectModelModifier ... modifiers) {
        ObjectModelAttributeImpl associationA = (ObjectModelAttributeImpl)attrAssociation;
        associationA.setReverseAttributeName(roleName);
        associationA.setReverseMaxMultiplicity(maxMultiplicity);
        ObjectModelClassifierImpl classifierA = (ObjectModelClassifierImpl)associationA.getDeclaringElement();
        String typeB = associationA.getType();
        ObjectModelClassifierImpl classifierB = (ObjectModelClassifierImpl)this.model.getClassifier(typeB);
        ObjectModelAttributeImpl associationB = (ObjectModelAttributeImpl)this.addAssociation(classifierB, classifierA, roleName, minMultiplicity, maxMultiplicity, modifiers);
        associationB.setReverseAttributeName(associationA.getName());
        associationB.setReverseMaxMultiplicity(associationA.getMaxMultiplicity());
        return associationB;
    }

    public ObjectModelAssociationClass createAssociationClass(String name, String packageName, ObjectModelAttribute attrAssociationA, ObjectModelAttribute attrAssociationB, ObjectModelModifier ... modifiers) {
        ObjectModelAssociationClassImpl associationClass = new ObjectModelAssociationClassImpl();
        this.createClass(associationClass, name, packageName, modifiers);
        ObjectModelAttributeImpl attrA = (ObjectModelAttributeImpl)attrAssociationA;
        attrA.setAssociationClassName(associationClass.getQualifiedName());
        ObjectModelAttributeImpl attrB = (ObjectModelAttributeImpl)attrAssociationB;
        attrB.setAssociationClassName(associationClass.getQualifiedName());
        ObjectModeImplAssociationClassParticipant participantA = new ObjectModeImplAssociationClassParticipant();
        participantA.setAttribute(attrA.getName());
        ObjectModelClassifier classifierA = (ObjectModelClassifier)attrA.getDeclaringElement();
        participantA.setName(classifierA.getQualifiedName());
        associationClass.addParticipant(participantA);
        ObjectModeImplAssociationClassParticipant participantB = new ObjectModeImplAssociationClassParticipant();
        participantB.setAttribute(attrB.getName());
        ObjectModelClassifier classifierB = (ObjectModelClassifier)attrB.getDeclaringElement();
        participantB.setName(classifierB.getQualifiedName());
        associationClass.addParticipant(participantB);
        return associationClass;
    }

    public ObjectModelOperation addOperation(ObjectModelClassifier classifier, String name, String returnType, ObjectModelModifier ... modifiers) throws IllegalArgumentException {
        ObjectModelOperationImpl result = new ObjectModelOperationImpl();
        result.setName(name);
        if (returnType != null) {
            ObjectModelParameterImpl returnParameter = new ObjectModelParameterImpl();
            returnParameter.setType(returnType);
            result.setReturnParameter(returnParameter);
        }
        result.addModifier(modifiers);
        ((ObjectModelClassifierImpl)classifier).addOperation(result);
        return result;
    }

    public ObjectModelOperation addOperation(ObjectModelClassifier classifier, ObjectModelOperation operation) {
        ((ObjectModelClassifierImpl)classifier).addOperation((ObjectModelOperationImpl)operation);
        return operation;
    }

    public void setOperationBody(ObjectModelOperation operation, String body) {
        ObjectModelOperationImpl operationImpl = (ObjectModelOperationImpl)operation;
        operationImpl.setBodyCode(body);
    }

    public void addInterface(ObjectModelClassifier classifier, String interfaceQualifiedName) {
        ObjectModelClassifierImpl impl = (ObjectModelClassifierImpl)classifier;
        ObjectModelImplRef interfacez = new ObjectModelImplRef();
        interfacez.setName(interfaceQualifiedName);
        impl.addInterface(interfacez);
    }

    public void addSuperclass(ObjectModelClass clazz, String superclassQualifiedName) {
        ObjectModelClassImpl impl = (ObjectModelClassImpl)clazz;
        ObjectModelImplSuperClassRef superclass = new ObjectModelImplSuperClassRef();
        superclass.setName(superclassQualifiedName);
        impl.addSuperclass(superclass);
    }

    public ObjectModelClassifier addInnerClassifier(ObjectModelClass clazz, ObjectModelType type, String name, ObjectModelModifier ... modifiers) throws IllegalArgumentException {
        ObjectModelClassifierImpl inner;
        ObjectModelClassImpl impl = (ObjectModelClassImpl)clazz;
        switch (type) {
            case OBJECT_MODEL_ENUMERATION: {
                inner = new ObjectModelEnumerationImpl();
                break;
            }
            case OBJECT_MODEL_CLASS: {
                inner = new ObjectModelClassImpl();
                this.setClassModifiers((ObjectModelClassImpl)inner, modifiers);
                break;
            }
            case OBJECT_MODEL_INTERFACE: {
                inner = new ObjectModelInterfaceImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException("can not add a none classifier type " + type);
            }
        }
        inner.setName(name);
        inner.setPackage(clazz.getPackageName() + "." + clazz.getName());
        inner.postInit();
        impl.addInnerClassifier(inner);
        inner.setObjectModelImpl(impl.getModel());
        if (log.isDebugEnabled()) {
            log.debug("Add inner classifier for " + clazz.getQualifiedName() + " : " + inner.getQualifiedName());
        }
        return inner;
    }

    public ObjectModelParameter addParameter(ObjectModelOperation operation, String type, String name) {
        ObjectModelOperationImpl impl = (ObjectModelOperationImpl)operation;
        ObjectModelParameterImpl param = new ObjectModelParameterImpl();
        param.setType(type);
        param.setName(name);
        impl.addParameter(param);
        return param;
    }

    public void addException(ObjectModelOperation operation, String exception) {
        ObjectModelOperationImpl impl = (ObjectModelOperationImpl)operation;
        ObjectModelParameterImpl param = new ObjectModelParameterImpl();
        param.setType(exception);
        impl.addExceptionParameter(param);
    }

    public void setDocumentation(ObjectModelElement element, String documentation) {
        ObjectModelElementImpl impl = (ObjectModelElementImpl)element;
        impl.setDocumentation(documentation);
    }

    public void addStereotype(ObjectModelElement element, String stereotype) {
        ObjectModelElementImpl impl = (ObjectModelElementImpl)element;
        ObjectModelImplRef ref = new ObjectModelImplRef();
        ref.setName(stereotype);
        impl.addStereotype(ref);
    }

    public void addLiteral(ObjectModelEnumeration enumz, String name) {
        ObjectModelEnumerationImpl impl = (ObjectModelEnumerationImpl)enumz;
        ObjectModelImplRef ref = new ObjectModelImplRef();
        ref.setName(name);
        impl.addLiteral(ref);
    }

    public void addComment(ObjectModelElement element, String comment) {
        ObjectModelElementImpl impl = (ObjectModelElementImpl)element;
        impl.addComment(comment);
    }

    public void setMinMultiplicity(ObjectModelAttribute attribute, int multiplicity) {
        ObjectModelAttributeImpl impl = (ObjectModelAttributeImpl)attribute;
        impl.setMinMultiplicity(multiplicity);
    }

    public void setMaxMultiplicity(ObjectModelAttribute attribute, int multiplicity) {
        ObjectModelAttributeImpl impl = (ObjectModelAttributeImpl)attribute;
        impl.setMaxMultiplicity(multiplicity);
    }

    public void setNavigable(ObjectModelAttribute attribute, boolean navigable) {
        ObjectModelAttributeImpl impl = (ObjectModelAttributeImpl)attribute;
        impl.setNavigable(navigable);
    }
}

