/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import com.google.common.base.Joiner;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.friend.ElementDef;
import org.nuiton.eugene.models.friend.ParameterDef;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.xml.ObjectModelOperationImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelParameterImpl;

public class OperationDef
extends ElementDef {
    private static final Logger log = LogManager.getLogger(OperationDef.class);
    private final String returnType;
    private String fullyQualifiedReturnType;
    private final List<ParameterDef> parameters = new LinkedList<ParameterDef>();

    public static OperationDef of(ObjectModelOperation anOperation, String defaultPackage) {
        OperationDef result = new OperationDef(anOperation.getName(), OperationDef.getRelativeType(anOperation.getReturnType(), defaultPackage));
        result.loadStereotypesAndTagValues(anOperation);
        for (ObjectModelParameter objectModelParameter : anOperation.getParameters()) {
            result.add(ParameterDef.of(objectModelParameter, defaultPackage));
        }
        return result;
    }

    public static OperationDef of(String lineDef) {
        Pair<String, String> pair = OperationDef.splitTagValues(lineDef, lineDef.indexOf(41));
        lineDef = (String)pair.getLeft();
        String tagValues = (String)pair.getRight();
        int parameterFirstIndex = lineDef.indexOf(40);
        int parameterLastIndex = lineDef.indexOf(41);
        String type = lineDef.substring(parameterLastIndex + 1).trim();
        String parameters = lineDef.substring(parameterFirstIndex, parameterLastIndex + 1).replace("(", "").replace(")", "");
        lineDef = lineDef.substring(0, parameterFirstIndex);
        OperationDef result = new OperationDef(lineDef.trim(), type);
        if (tagValues != null) {
            result.loadStereotypesAndTagValues(tagValues);
        }
        if (!parameters.isEmpty()) {
            for (String parameter : parameters.split(",")) {
                ParameterDef parameterDef = ParameterDef.of(parameter.trim());
                result.add(parameterDef);
            }
        }
        return result;
    }

    private OperationDef(String name, String returnType) {
        super(name);
        this.returnType = returnType;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getFullyQualifiedReturnType() {
        return this.fullyQualifiedReturnType;
    }

    public List<ParameterDef> getParameters() {
        return this.parameters;
    }

    public void add(ParameterDef parameterDef) {
        log.debug(String.format("Add parameter: %s on %s", parameterDef, this.getName()));
        this.parameters.add(parameterDef);
    }

    public String toString() {
        return this.getName() + (String)(this.parameters.isEmpty() ? "()" : "(" + Joiner.on((String)",").join(this.parameters) + ")") + ":" + this.returnType;
    }

    @Override
    public void write(BufferedWriter writer) throws IOException {
        writer.newLine();
        writer.append(this.getName());
        if (this.parameters.isEmpty()) {
            writer.append("()");
        } else {
            writer.append("(");
            this.write(writer, this.parameters, ", ");
            writer.append(")");
        }
        if (!this.returnType.isEmpty()) {
            writer.append(" ").append(this.returnType);
        }
        this.writeStereotypesAndTagValues(writer);
    }

    void resolveTypes(Map<String, String> classesMapping) {
        this.fullyQualifiedReturnType = this.resolveType(this.getReturnType(), classesMapping);
        for (ParameterDef parameterDef : this.getParameters()) {
            parameterDef.resolveType(classesMapping);
        }
    }

    ObjectModelOperationImpl toObjectModel() {
        ObjectModelOperationImpl result = new ObjectModelOperationImpl();
        result.setName(this.getName());
        this.flushStereotypesAndTagValues(result);
        ObjectModelParameterImpl returnParameter = new ObjectModelParameterImpl();
        returnParameter.setType(this.getFullyQualifiedReturnType());
        result.setReturnParameter(returnParameter);
        for (ParameterDef parameter : this.parameters) {
            result.addParameter(parameter.toObjectModel());
        }
        return result;
    }
}

