/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import com.google.common.base.Joiner;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.friend.ClassifierDef;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.xml.ObjectModelEnumerationImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;

public class EnumDef
extends ClassifierDef<EnumDef> {
    static final String PREFIX = "enum ";
    private static final Logger log = LogManager.getLogger(EnumDef.class);
    private final List<String> literals = new LinkedList<String>();

    public static EnumDef of(ObjectModelEnumeration anEnumeration, String defaultPackage) {
        EnumDef result = new EnumDef(EnumDef.getRelativeType(anEnumeration.getQualifiedName(), defaultPackage), defaultPackage);
        result.loadStereotypesAndTagValues(anEnumeration);
        for (String literal : anEnumeration.getLiterals()) {
            result.add(literal);
        }
        return result;
    }

    public static EnumDef of(String line, List<String> groupLines, String defaultPackage) {
        String firstLine = StringUtils.removeStart((String)line, (String)PREFIX).trim();
        Pair<String, String> pair = EnumDef.splitTagValues(firstLine);
        firstLine = (String)pair.getLeft();
        String tagValues = (String)pair.getRight();
        EnumDef result = new EnumDef(firstLine.trim(), defaultPackage);
        if (tagValues != null) {
            result.loadStereotypesAndTagValues(tagValues);
        }
        for (String groupLine : groupLines) {
            result.add(groupLine.trim());
        }
        return result;
    }

    private EnumDef(String name, String defaultPackage) {
        super(name, defaultPackage);
    }

    @Override
    public void write(BufferedWriter writer) throws IOException {
        writer.newLine();
        writer.append(PREFIX).append(this.getName());
        this.writeStereotypesAndTagValues(writer);
        for (String literal : this.literals) {
            writer.newLine();
            writer.append(literal);
        }
        writer.newLine();
    }

    public void add(String literal) {
        log.debug(String.format("Add literal: %s on %s", literal, this.getName()));
        this.literals.add(literal);
    }

    public List<String> getLiterals() {
        return this.literals;
    }

    public String toString() {
        return this.getName() + (String)(this.literals.isEmpty() ? "" : "(" + Joiner.on((String)",").join(this.literals) + ")");
    }

    public ObjectModelEnumerationImpl toObjectModel() {
        ObjectModelEnumerationImpl result = new ObjectModelEnumerationImpl();
        this.toObjectModel(result);
        for (String literal : this.literals) {
            ObjectModelImplRef ref = new ObjectModelImplRef();
            ref.setName(literal);
            result.addLiteral(ref);
        }
        return result;
    }
}

