/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.friend;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.extension.tagvalue.WithTagValuesOrStereotypes;

public abstract class ElementDef {
    private static final Logger log = LogManager.getLogger(ElementDef.class);
    private final String name;
    private final Set<String> stereotypes = new LinkedHashSet<String>();
    private final Map<String, String> tagValues = new TreeMap<String, String>();
    private static final Set<String> IGNORED_TAG_VALUES = ImmutableSet.of((Object)"documentation", (Object)"since", (Object)"author");
    private static ImmutableSet<String> PRIMITIVES = ImmutableSet.of((Object)"boolean", (Object)"byte", (Object)"char", (Object)"int", (Object)"float", (Object)"double", (Object[])new String[]{"long"});
    private static ImmutableSet<String> PRIMITIVES_OBJECTS = ImmutableSet.of((Object)"String", (Object)"Boolean", (Object)"Byte", (Object)"Character", (Object)"Integer", (Object)"Float", (Object[])new String[]{"Double", "Long"});
    private static ImmutableSet<String> PRIMITIVES_OBJECTS2 = ImmutableSet.of((Object)"java.lang.String", (Object)"java.lang.Boolean", (Object)"java.lang.Byte", (Object)"java.lang.Character", (Object)"java.lang.Integer", (Object)"java.lang.Float", (Object[])new String[]{"java.lang.Double", "java.lang.Long"});
    private static ImmutableSet<String> JAVA_UTIL = ImmutableSet.of((Object)"Collection", (Object)"Set", (Object)"List", (Object)"Map", (Object)"Date");

    ElementDef(String name) {
        this.name = name;
    }

    public abstract void write(BufferedWriter var1) throws IOException;

    public void addStereotype(String stereotype) {
        log.debug(String.format("Add stereotype: %s on %s", stereotype, this.name));
        this.stereotypes.add(stereotype);
    }

    public void addTagValue(String key, String value) {
        if (IGNORED_TAG_VALUES.contains(key)) {
            return;
        }
        if ("true".equals(value)) {
            this.addStereotype(key);
        } else {
            log.debug(String.format("Add tag value: %s=%s on %s", key, value, this.name));
            this.tagValues.put(key, value);
        }
    }

    void flushStereotypesAndTagValues(WithTagValuesOrStereotypes model) {
        for (String string : this.stereotypes) {
            model.addTagValue(string, "true");
        }
        for (Map.Entry entry : this.tagValues.entrySet()) {
            model.addTagValue((String)entry.getKey(), (String)entry.getValue());
        }
    }

    void loadStereotypesAndTagValues(String tagValues) {
        String[] parts;
        for (String part : parts = tagValues.split("\\s+")) {
            part = part.trim();
            String[] tagValueParts = part.split("=");
            String firstPart = tagValueParts[0].trim();
            if (tagValueParts.length == 1) {
                this.addStereotype(firstPart);
                continue;
            }
            String secondPart = tagValueParts[1].trim();
            this.addTagValue(firstPart, secondPart);
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getStereotypes() {
        return this.stereotypes;
    }

    public Map<String, String> getTagValues() {
        return this.tagValues;
    }

    void writeSimpleList(List<String> list, String prefix, BufferedWriter writer) throws IOException {
        if (!list.isEmpty()) {
            writer.append(prefix);
            boolean first = true;
            for (String one : list) {
                if (first) {
                    first = false;
                } else {
                    writer.append(",");
                }
                writer.append(one);
            }
        }
    }

    void writeStereotypesAndTagValues(BufferedWriter writer) throws IOException {
        if (this.getStereotypes().isEmpty() && this.getTagValues().isEmpty()) {
            return;
        }
        writer.append(" |");
        for (String string : this.stereotypes) {
            writer.append(" ").append(string);
        }
        for (Map.Entry entry : this.tagValues.entrySet()) {
            writer.append(" ").append((CharSequence)entry.getKey()).append("=").append((CharSequence)entry.getValue());
        }
    }

    String resolveType(String value, Map<String, String> classesMapping) {
        if (value.isEmpty()) {
            return "void";
        }
        if (value.startsWith("!")) {
            return value.substring(1);
        }
        Object result = classesMapping.get(value);
        if (result == null) {
            if (PRIMITIVES_OBJECTS.contains((Object)value)) {
                result = "java.lang." + value;
            } else if (JAVA_UTIL.contains((Object)value)) {
                result = "java.util." + value;
            } else {
                for (String s : JAVA_UTIL) {
                    if (!value.startsWith(s + "<")) continue;
                    return "java.util." + value;
                }
                result = value;
            }
        }
        return result;
    }

    void loadStereotypesAndTagValues(WithTagValuesOrStereotypes model) {
        for (String string : model.getStereotypes()) {
            this.addStereotype(string);
        }
        for (Map.Entry entry : model.getTagValues().entrySet()) {
            this.addTagValue((String)entry.getKey(), (String)entry.getValue());
        }
    }

    void write(BufferedWriter writer, Collection<? extends ElementDef> defs, String separator) throws IOException {
        boolean first = true;
        for (ElementDef elementDef : defs) {
            if (first) {
                first = false;
            } else {
                writer.append(separator);
            }
            elementDef.write(writer);
        }
    }

    static String getRelativeType(String name, String defaultPackage) {
        if (PRIMITIVES.contains((Object)name) || PRIMITIVES_OBJECTS.contains((Object)name) || JAVA_UTIL.contains((Object)name)) {
            return name;
        }
        if (PRIMITIVES_OBJECTS2.contains((Object)name)) {
            return StringUtils.removeStart((String)name, (String)"java.lang.");
        }
        for (String s : JAVA_UTIL) {
            if (!name.startsWith("java.util." + s)) continue;
            return s + StringUtils.removeStart((String)name, (String)("java.util." + s));
        }
        if (Objects.equals(name, "") || "void".equals(name)) {
            return "";
        }
        int indexOf = name.indexOf(defaultPackage);
        return indexOf == 0 ? name.substring(indexOf + defaultPackage.length()) : "!" + name;
    }

    static Pair<String, String> splitTagValues(String line) {
        return ElementDef.splitTagValues(line, 0);
    }

    static Pair<String, String> splitTagValues(String line, int pos) {
        int tagValuesIndexOf = line.indexOf(124, pos);
        if (tagValuesIndexOf != -1) {
            String tagValues = line.substring(tagValuesIndexOf + 1).trim();
            line = line.substring(0, tagValuesIndexOf - 1);
            return Pair.of((Object)line, (Object)tagValues);
        }
        return Pair.of((Object)line, null);
    }
}

