/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.tagvalue.provider;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import org.nuiton.eugene.models.extension.tagvalue.MismatchTagValueTargetException;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueNotFoundException;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;

public class AggregateTagValueMetadatasProvider
implements TagValueMetadatasProvider,
Iterable<TagValueMetadatasProvider> {
    protected final Iterable<TagValueMetadatasProvider> providers;

    public AggregateTagValueMetadatasProvider(ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        this.providers = ServiceLoader.load(TagValueMetadatasProvider.class, loader);
    }

    public AggregateTagValueMetadatasProvider(Iterable<TagValueMetadatasProvider> providers) {
        Preconditions.checkNotNull(providers);
        this.providers = providers;
    }

    @Override
    public Iterator<TagValueMetadatasProvider> iterator() {
        return this.providers.iterator();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Set<TagValueMetadata> getTagValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TagValueMetadatasProvider tagValuesMetadatasProvider : this.providers) {
            builder.addAll(tagValuesMetadatasProvider.getTagValues());
        }
        return builder.build();
    }

    @Override
    public Optional<TagValueMetadata> getTagValue(String tagValueName) {
        for (TagValueMetadatasProvider provider : this.providers) {
            Optional<TagValueMetadata> result = provider.getTagValue(tagValueName);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.absent();
    }

    @Override
    public void validate(String tagValueName, Class<?> type) throws TagValueNotFoundException, MismatchTagValueTargetException {
        for (TagValueMetadatasProvider provider : this.providers) {
            try {
                provider.validate(tagValueName, type);
                return;
            }
            catch (TagValueNotFoundException tagValueNotFoundException) {
            }
        }
        throw new TagValueNotFoundException();
    }
}

