/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.extension.tagvalue;

import com.google.common.base.Joiner;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelPackage;

public class MissingTagValueException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected final String tagValueName;
    protected final String tagValueValue;
    protected final String prefixMessage;
    protected final Set<String> stack;

    public MissingTagValueException(String tagValueName, String tagValueValue, String prefixMessage, ObjectModelPackage aPackage, ObjectModelClass aClass) {
        this.tagValueName = tagValueName;
        this.tagValueValue = tagValueValue;
        this.prefixMessage = prefixMessage;
        this.stack = this.getUsageStack(tagValueName, tagValueValue, aPackage, aClass);
    }

    @Override
    public String toString() {
        return "\n\n" + this.prefixMessage + "\n==========================================================================================\n" + Joiner.on((String)"\n").join(this.stack) + "\n==========================================================================================";
    }

    protected LinkedHashSet<String> getUsageStack(String tagValueName, String tagValueValue, ObjectModelPackage aPackage, ObjectModelClass aClass) {
        String suffix = ".tagvalue." + tagValueName + "=" + tagValueValue;
        LinkedHashSet<String> stack = new LinkedHashSet<String>();
        stack.add("model" + suffix);
        this.addPackageTagValue(aPackage, suffix, stack);
        stack.add(aClass.getQualifiedName() + ".class" + suffix);
        return stack;
    }

    protected void addPackageTagValue(ObjectModelPackage aPackage, String suffix, Set<String> stack) {
        if (aPackage.getParentPackage() != null) {
            this.addPackageTagValue(aPackage.getParentPackage(), suffix, stack);
        }
        stack.add("package." + aPackage.getName() + suffix);
    }
}

