/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java.extension;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.java.extension.ImportsManager;
import org.nuiton.eugene.models.object.ObjectModelClassifier;

public class ImportsManagerExtension {
    private static final Logger log = LogManager.getLogger(ImportsManagerExtension.class);
    public static final String OBJECTMODEL_EXTENSION = "imports";
    protected Map<String, ImportsManager> managers;

    public ImportsManager getManager(ObjectModelClassifier classifier) {
        String fqn = classifier.getQualifiedName();
        ImportsManager manager = this.getManager(fqn);
        return manager;
    }

    public ImportsManager getManager(String fqn) {
        Map<String, ImportsManager> managers = this.getManagers();
        ImportsManager manager = managers.get(fqn);
        if (manager == null) {
            manager = new ImportsManager();
            managers.put(fqn, manager);
            if (log.isDebugEnabled()) {
                log.debug("Add new importsManager for : " + fqn);
            }
        }
        return manager;
    }

    public List<String> getImports(ObjectModelClassifier classifier) {
        List<String> imports = this.getImports(classifier.getQualifiedName(), classifier.getPackageName());
        return imports;
    }

    public List<String> getImports(String fqn, String packageName) {
        ImportsManager manager = this.getManager(fqn);
        return manager.getImports(packageName);
    }

    protected Map<String, ImportsManager> getManagers() {
        if (this.managers == null) {
            this.managers = new HashMap<String, ImportsManager>();
        }
        return this.managers;
    }
}

