/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;

public class ImportsManager {
    private static Set<String> primitiveTypes = new HashSet<String>();
    private Map<String, String> imports = new HashMap<String, String>();
    private final Set<String> excludedPatterns = new TreeSet<String>();
    private State state = State.FILLING;

    public void addExcludedPattern(String excludePattern) {
        this.excludedPatterns.add(excludePattern);
    }

    public boolean addImport(Class<?> clazz) {
        return this.addImport(clazz.getName());
    }

    public boolean exclude(String fqn) {
        for (String excludedPattern : this.excludedPatterns) {
            if (!fqn.matches(excludedPattern)) continue;
            return true;
        }
        return false;
    }

    public String importAndSimplify(String fqn) {
        String existingImport = this.imports.get(fqn);
        if (existingImport != null) {
            return existingImport;
        }
        boolean wasImported = this.addImport(fqn);
        if (wasImported) {
            return JavaGeneratorUtil.getSimpleName(fqn);
        }
        return fqn;
    }

    public boolean addImport(String fqn) {
        if (fqn == null) {
            return false;
        }
        if (this.exclude(fqn)) {
            return false;
        }
        int lastDotIndex = this.getLastDotIndex(fqn);
        if (lastDotIndex == -1) {
            return true;
        }
        if (fqn.trim().isEmpty() || fqn.startsWith("java.lang.") && lastDotIndex == 9) {
            return true;
        }
        if (primitiveTypes.contains(fqn)) {
            return false;
        }
        if (fqn.endsWith("[]")) {
            String simpleFQN = fqn.substring(0, fqn.length() - 2);
            return this.addImport(simpleFQN);
        }
        if (JavaGeneratorUtil.containsGenerics(fqn)) {
            String[] parts = JavaGeneratorUtil.splitGeneric(fqn);
            boolean doImport = false;
            if (this.addImport(parts[0])) {
                doImport = true;
            }
            int partsLength = parts.length;
            for (int i = 1; i < partsLength; ++i) {
                String part = parts[i];
                this.addImport(part);
            }
            return doImport;
        }
        String name = fqn.substring(lastDotIndex + 1);
        String inPlaceFqn = this.imports.get(name);
        if (inPlaceFqn == null) {
            if (this.state == State.READING) {
                return false;
            }
            this.imports.put(name, fqn);
            return true;
        }
        return inPlaceFqn.equals(fqn);
    }

    public String getType(Class<?> clazz) {
        String type = this.getType(clazz.getName());
        return type;
    }

    public String getType(String fqn) {
        boolean importResult = this.addImport(fqn);
        if (JavaGeneratorUtil.containsGenerics(fqn)) {
            String[] parts = JavaGeneratorUtil.splitGeneric(fqn);
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                parts[i] = this.getType(part);
            }
            return JavaGeneratorUtil.joinGeneric(parts);
        }
        if (!importResult) {
            return fqn;
        }
        int packageEndIndex = this.getLastDotIndex(fqn);
        if (packageEndIndex == -1) {
            return fqn;
        }
        return fqn.substring(packageEndIndex + 1);
    }

    public String getReturnType(String returnType) {
        if (StringUtils.isBlank((CharSequence)returnType)) {
            return null;
        }
        if (JavaGeneratorUtil.containsGenerics(returnType)) {
            String[] parts = GeneratorUtil.splitGenericDefinition(returnType);
            if (parts.length == 1) {
                return this.getType(returnType);
            }
            Object genericDef = parts[0];
            String strictReturnType = parts[1];
            if (StringUtils.isNotBlank((CharSequence)genericDef)) {
                genericDef = (String)genericDef + " ";
            }
            return (String)genericDef + this.getType(strictReturnType);
        }
        return this.getType(returnType);
    }

    public List<String> getImports(String packageName) {
        this.state = State.READING;
        ArrayList<String> result = new ArrayList<String>();
        int packageLength = packageName.length();
        String packagePrefix = packageName + ".";
        for (String fqn : this.imports.values()) {
            int lastDotIndex = this.getLastDotIndex(fqn);
            if (lastDotIndex == packageLength && fqn.startsWith(packagePrefix)) continue;
            result.add(fqn);
        }
        Collections.sort(result);
        return result;
    }

    public void clearImports() {
        this.imports.clear();
        this.state = State.FILLING;
    }

    public int getLastDotIndex(String fqn) {
        return fqn.lastIndexOf(".");
    }

    static {
        primitiveTypes.add("byte");
        primitiveTypes.add("Byte");
        primitiveTypes.add("short");
        primitiveTypes.add("Short");
        primitiveTypes.add("int");
        primitiveTypes.add("Integer");
        primitiveTypes.add("long");
        primitiveTypes.add("Long");
        primitiveTypes.add("float");
        primitiveTypes.add("Float");
        primitiveTypes.add("double");
        primitiveTypes.add("Double");
        primitiveTypes.add("char");
        primitiveTypes.add("Char");
        primitiveTypes.add("String");
        primitiveTypes.add("boolean");
        primitiveTypes.add("Boolean");
        primitiveTypes.add("void");
    }

    private static enum State {
        FILLING,
        READING;

    }
}

