/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java.extension;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.java.extension.AnnotationsManager;
import org.nuiton.eugene.java.extension.ObjectModelAnnotation;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;

public class AnnotationsManagerExtension {
    private static final Logger log = LogManager.getLogger(AnnotationsManagerExtension.class);
    public static final String OBJECTMODEL_EXTENSION = "annotations";
    protected Map<String, AnnotationsManager> managers;

    public List<ObjectModelAnnotation> getAnnotations(ObjectModelClassifier classifier, ObjectModelElement element) {
        AnnotationsManager annotationsManager = this.getManager(classifier);
        List<ObjectModelAnnotation> result = null;
        if (annotationsManager != null) {
            result = annotationsManager.getAnnotations(element);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public AnnotationsManager getManager(ObjectModelClassifier classifier) {
        String fqn;
        Map<String, AnnotationsManager> managers = this.getManagers();
        AnnotationsManager manager = managers.get(fqn = classifier.getQualifiedName());
        if (manager == null) {
            manager = new AnnotationsManager();
            managers.put(fqn, manager);
            if (log.isDebugEnabled()) {
                log.debug("Add new annotationsManager for : " + fqn);
            }
        }
        return manager;
    }

    protected Map<String, AnnotationsManager> getManagers() {
        if (this.managers == null) {
            this.managers = new HashMap<String, AnnotationsManager>();
        }
        return this.managers;
    }
}

