/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import io.ultreia.java4all.i18n.I18n;
import io.ultreia.java4all.lang.Strings;
import java.beans.Introspector;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.java.JavaBuilder;
import org.nuiton.eugene.java.JavaGenerator;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ServiceLoaderUtil;
import org.nuiton.eugene.java.extension.ImportsManager;
import org.nuiton.eugene.java.extension.ObjectModelAnnotation;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.ObjectModelTransformer;
import org.nuiton.eugene.models.object.ObjectModelType;

public abstract class ObjectModelTransformerToJava
extends ObjectModelTransformer<ObjectModel> {
    private static final Logger log = LogManager.getLogger(ObjectModelTransformerToJava.class);
    protected JavaBuilder builder;
    private String constantPrefix;
    protected final EugeneCoreTagValues eugeneTagValues = new EugeneCoreTagValues();

    @Override
    protected Template<ObjectModel> initOutputTemplate() {
        return new JavaGenerator();
    }

    @Override
    protected ObjectModel initOutputModel() {
        if (log.isDebugEnabled()) {
            log.debug("inputModelName = " + ((ObjectModel)this.getModel()).getName());
        }
        this.builder = new JavaBuilder(((ObjectModel)this.getModel()).getName());
        this.setConstantPrefix("");
        return this.builder.getModel();
    }

    protected ImportsManager getImportManager(ObjectModelClass clazz) {
        return this.builder.getImportManager(clazz);
    }

    @Override
    protected void debugOutputModel() {
        if (log.isDebugEnabled()) {
            log.debug("classes : " + ((ObjectModel)this.getOutputModel()).getClasses().size());
            for (ObjectModelClass clazz : ((ObjectModel)this.getOutputModel()).getClasses()) {
                log.debug("  class : " + clazz.getQualifiedName());
                ImportsManager manager = this.getImportManager(clazz);
                for (String imports : manager.getImports(clazz.getPackageName())) {
                    log.debug("  import : " + imports);
                }
                for (ObjectModelAttribute attribute : clazz.getAttributes()) {
                    log.debug("  attribute : " + attribute.getType() + " " + attribute.getName());
                }
                for (ObjectModelOperation operation : clazz.getOperations()) {
                    log.debug("  operation : " + operation.getReturnType() + " " + operation.getName());
                }
            }
        }
    }

    protected void addGeneratedAnnotation(ObjectModelClassifier element) {
        String generatorName = this.getClass().getName();
        Date now = new Date();
        ObjectModelAnnotation annotation = this.addAnnotation(element, (ObjectModelElement)element, Generated.class);
        this.addAnnotationParameter(element, annotation, "value", generatorName);
        this.addAnnotationParameter(element, annotation, "date", now.toString());
    }

    protected ObjectModelClass createClass(String name, String packageName) {
        ObjectModelClass result = this.builder.createClass(name, packageName, new ObjectModelModifier[0]);
        this.addGeneratedAnnotation(result);
        return result;
    }

    protected ObjectModelPackage getPackage(ObjectModelClassifier input) {
        return ((ObjectModel)this.model).getPackage(input);
    }

    protected ObjectModelPackage getPackage(String packageName) {
        return ((ObjectModel)this.model).getPackage(packageName);
    }

    public ObjectModelEnumeration createEnumeration(String name, String packageName) {
        ObjectModelEnumeration result = this.builder.createEnumeration(name, packageName);
        this.addGeneratedAnnotation(result);
        return result;
    }

    protected ObjectModelClass createAbstractClass(String name, String packageName) {
        ObjectModelClass result = this.builder.createAbstractClass(name, packageName);
        this.addGeneratedAnnotation(result);
        return result;
    }

    protected ObjectModelInterface createInterface(String name, String packageName) {
        ObjectModelInterface result = this.builder.createInterface(name, packageName);
        this.addGeneratedAnnotation(result);
        return result;
    }

    protected void setSuperClass(ObjectModelClass classifier, String superclassQualifiedName) {
        this.builder.setSuperClass(classifier, superclassQualifiedName);
    }

    protected void setSuperClass(ObjectModelClass classifier, Class<?> superclassQualifiedName) {
        this.setSuperClass(classifier, superclassQualifiedName.getName());
    }

    protected void addInterface(ObjectModelClassifier classifier, String interfaceQualifiedName) {
        this.builder.addInterface(classifier, interfaceQualifiedName);
    }

    protected void addInterface(ObjectModelClassifier classifier, Class<?> interfaceQualifiedName) {
        this.addInterface(classifier, interfaceQualifiedName.getName());
    }

    protected void addImport(ObjectModelClassifier classifier, String imports) {
        this.builder.addImport(classifier, imports);
    }

    protected void addImport(ObjectModelClassifier classifier, ObjectModelClass imports) {
        this.addImport(classifier, imports.getPackageName() + "." + imports.getName());
    }

    protected void addImport(ObjectModelClassifier classifier, Class<?> imports) {
        this.addImport(classifier, imports.getName());
    }

    protected String importAndSimplify(ObjectModelClassifier classifier, String imports) {
        return this.builder.importAndSimplify(classifier, imports);
    }

    public void addTagValue(String name, String value) {
        this.builder.addTagValue(name, value);
    }

    public void addTagValue(ObjectModelElement element, String name, String value) {
        this.builder.addTagValue(element, name, value);
    }

    public String getConstantName(String propertyName) {
        return this.getConstantPrefix() + this.builder.getConstantName(propertyName);
    }

    protected String getConstantPrefix(ObjectModelClassifier input) {
        String prefix = this.eugeneTagValues.getConstantPrefixTagValue(input, input == null ? null : this.getPackage(input), (ObjectModel)this.getModel());
        return prefix.trim();
    }

    protected ObjectModelAttribute addConstant(ObjectModelClassifier classifier, String name, String type, String value, ObjectModelModifier visibility) throws IllegalArgumentException {
        return this.builder.addConstant(classifier, name, type, value, visibility);
    }

    protected ObjectModelAttribute addConstant(ObjectModelClassifier classifier, String name, Class<?> type, String value, ObjectModelModifier visibility) throws IllegalArgumentException {
        return this.addConstant(classifier, name, type.getName(), value, visibility);
    }

    protected ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, String name, String type, String value, ObjectModelModifier ... modifiers) {
        return this.builder.addAttribute(classifier, name, type, value, modifiers);
    }

    protected ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, String name, Class<?> type, String value, ObjectModelModifier ... modifiers) {
        return this.addAttribute(classifier, name, type.getName(), value, modifiers);
    }

    protected ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, ObjectModelAttribute attribute) {
        return this.addAttribute(classifier, attribute.getName(), attribute.getType());
    }

    public ObjectModelAttribute addAttribute(ObjectModelClassifier classifier, String name, String type) {
        return this.builder.addAttribute(classifier, name, type);
    }

    protected ObjectModelOperation addConstructor(ObjectModelClass clazz, ObjectModelModifier visibility) throws IllegalArgumentException {
        return this.builder.addConstructor(clazz, visibility);
    }

    protected ObjectModelOperation addConstructor(ObjectModelEnumeration clazz, ObjectModelModifier visibility) throws IllegalArgumentException {
        return this.builder.addConstructor(clazz, visibility);
    }

    protected ObjectModelOperation addOperation(ObjectModelClassifier classifier, String name, String type, ObjectModelModifier ... modifiers) {
        return this.builder.addOperation(classifier, name, type, modifiers);
    }

    protected ObjectModelOperation addOperation(ObjectModelClassifier classifier, String name, Class<?> type, ObjectModelModifier ... modifiers) {
        return this.addOperation(classifier, name, type == null ? null : type.getName(), modifiers);
    }

    protected ObjectModelOperation addOperation(ObjectModelClassifier classifier, ObjectModelOperation operation) {
        return this.builder.addOperation(classifier, operation);
    }

    protected void addLiteral(ObjectModelEnumeration classifier, String name) {
        this.builder.addLiteral(classifier, name);
    }

    protected ObjectModelParameter addParameter(ObjectModelOperation operation, String type, String name) {
        return this.builder.addParameter(operation, type, name);
    }

    protected ObjectModelParameter addParameter(ObjectModelOperation operation, Class<?> type, String name) {
        return this.addParameter(operation, type.getName(), name);
    }

    protected void addException(ObjectModelOperation operation, String exception) {
        this.builder.addException(operation, exception);
    }

    protected void addException(ObjectModelOperation operation, Class<?> exception) {
        this.addException(operation, exception.getName());
    }

    protected void setOperationBody(ObjectModelOperation operation, String body) throws IllegalArgumentException {
        this.builder.setOperationBody(operation, body);
    }

    public ObjectModelClassifier addInnerClassifier(ObjectModelClass clazz, ObjectModelType type, String name, ObjectModelModifier ... modifiers) throws IllegalArgumentException {
        return this.builder.addInnerClassifier(clazz, type, name, modifiers);
    }

    public void setDocumentation(ObjectModelElement element, String documentation) {
        this.builder.setDocumentation(element, documentation);
    }

    public void setMinMultiplicity(ObjectModelAttribute attribute, int multiplicity) {
        this.builder.setMinMultiplicity(attribute, multiplicity);
    }

    public void setMaxMultiplicity(ObjectModelAttribute attribute, int multiplicity) {
        this.builder.setMaxMultiplicity(attribute, multiplicity);
    }

    public void setNavigable(ObjectModelAttribute attribute, boolean navigable) {
        this.builder.setNavigable(attribute, navigable);
    }

    public void addComment(ObjectModelElement element, String comment) {
        this.builder.addComment(element, comment);
    }

    public ObjectModelAnnotation addAnnotation(ObjectModelClassifier classifier, ObjectModelElement element, String annotationType) {
        return this.builder.addAnnotation(classifier, element, annotationType);
    }

    public ObjectModelAnnotation addAnnotation(ObjectModelClassifier classifier, ObjectModelElement element, Class<?> annotationType) {
        this.addImport(classifier, annotationType);
        return this.builder.addAnnotation(classifier, element, annotationType.getSimpleName());
    }

    public ObjectModelAnnotation addAnnotationParameter(ObjectModelClassifier classifier, ObjectModelAnnotation annotation, String annotationName, Object annotationValue) {
        if (annotationValue instanceof Enum) {
            Enum value = (Enum)annotationValue;
            this.addImport(classifier, value.getClass());
        }
        return this.builder.addAnnotationParameter(annotation, annotationName, annotationValue);
    }

    public ObjectModelOperation addBlock(ObjectModelClassifier classifier, ObjectModelModifier ... modifiers) {
        return this.builder.addBlock(classifier, modifiers);
    }

    public void addStereotype(ObjectModelElement element, String stereotype) {
        this.builder.addStereotype(element, stereotype);
    }

    public ObjectModelOperation cloneOperationSignature(ObjectModelOperation source, ObjectModelClassifier destination, boolean cloneDocumentation, ObjectModelModifier ... modifiers) {
        ObjectModelOperation outputOperation = this.addOperation(destination, source.getName(), source.getReturnType(), modifiers);
        if (cloneDocumentation && GeneratorUtil.hasDocumentation(source)) {
            this.setDocumentation(outputOperation, source.getDocumentation());
        }
        for (ObjectModelParameter parameter : source.getParameters()) {
            ObjectModelParameter outputParam = this.addParameter(outputOperation, parameter.getType(), parameter.getName());
            if (!cloneDocumentation || !GeneratorUtil.hasDocumentation(parameter)) continue;
            this.setDocumentation(outputParam, parameter.getDocumentation());
        }
        for (String exception : source.getExceptions()) {
            this.addException(outputOperation, exception);
        }
        this.cloneTagValues(source, outputOperation);
        return outputOperation;
    }

    public ObjectModelOperation cloneOperation(ObjectModelOperation source, ObjectModelClassifier destination, boolean cloneDocumentation, ObjectModelJavaModifier ... modifiers) {
        ObjectModelOperation outputOperation = this.cloneOperationSignature(source, destination, cloneDocumentation, modifiers);
        boolean opAbstract = false;
        for (ObjectModelJavaModifier modifier : modifiers) {
            if (modifier != ObjectModelJavaModifier.ABSTRACT) continue;
            opAbstract = true;
            break;
        }
        if (!opAbstract) {
            this.setOperationBody(outputOperation, source.getBodyCode());
        }
        return outputOperation;
    }

    protected ObjectModelAttribute cloneAttribute(ObjectModelAttribute source, ObjectModelClassifier destination, boolean cloneDocumentation, ObjectModelModifier ... modifiers) {
        ObjectModelAttribute outputAttribute = this.addAttribute(destination, source.getName(), source.getType(), source.getDefaultValue(), modifiers);
        this.cloneTagValues(source, outputAttribute);
        if (cloneDocumentation) {
            this.setDocumentation(outputAttribute, source.getDocumentation());
        }
        for (String comment : source.getComments()) {
            this.addComment(outputAttribute, comment);
        }
        this.setMinMultiplicity(outputAttribute, source.getMinMultiplicity());
        this.setMaxMultiplicity(outputAttribute, source.getMaxMultiplicity());
        this.setNavigable(outputAttribute, source.isNavigable());
        return outputAttribute;
    }

    protected void cloneTagValues(ObjectModelElement source, ObjectModelElement destination) {
        Map<String, String> tags = source.getTagValues();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.addTagValue(destination, entry.getKey(), entry.getValue());
        }
    }

    protected void cloneStereotypes(ObjectModelClassifier source, ObjectModelClassifier destination) {
        Set<String> stereotypes = source.getStereotypes();
        for (String stereotype : stereotypes) {
            this.addStereotype(destination, stereotype);
        }
    }

    @Deprecated
    protected void copyClassifier(ObjectModelClassifier source, ObjectModelClassifier destination, boolean copyDocumentation) {
        this.cloneClassifier(source, destination, copyDocumentation);
    }

    protected void cloneClassifier(ObjectModelClassifier source, ObjectModelClassifier destination, boolean copyDocumentation) {
        this.cloneTagValues(source, destination);
        this.cloneStereotypes(source, destination);
        for (ObjectModelAttribute attribute : source.getAttributes()) {
            this.cloneAttribute(attribute, destination, copyDocumentation, new ObjectModelModifier[0]);
        }
        for (ObjectModelInterface interfacez : source.getInterfaces()) {
            this.addInterface(destination, interfacez.getQualifiedName());
        }
        for (ObjectModelOperation operation : source.getOperations()) {
            this.cloneOperation(operation, destination, copyDocumentation, new ObjectModelJavaModifier[0]);
        }
    }

    public ObjectModelClass cloneClass(ObjectModelClass source, boolean cloneDocumentation) {
        ObjectModelClass outputClass = this.createClass(source.getName(), source.getPackageName());
        this.cloneClassifier(source, outputClass, cloneDocumentation);
        if (source.getSuperclasses().size() > 1) {
            log.warn(source.getQualifiedName() + " has multiple inheritence, some of them will be ignored");
        }
        for (ObjectModelClass superClass : source.getSuperclasses()) {
            this.setSuperClass(outputClass, superClass.getQualifiedName());
        }
        if (!CollectionUtils.isEmpty(source.getInnerClassifiers())) {
            for (ObjectModelClassifier classifier : source.getInnerClassifiers()) {
                ObjectModelClassifier innerClassifierClone = this.cloneClassifier(classifier, cloneDocumentation);
                this.addInnerClassifier(outputClass, ObjectModelType.OBJECT_MODEL_CLASSIFIER, innerClassifierClone.getName(), new ObjectModelModifier[0]);
            }
        }
        return outputClass;
    }

    public ObjectModelInterface cloneInterface(ObjectModelInterface source, boolean cloneDocumentation) {
        ObjectModelInterface outputInterface = this.createInterface(source.getName(), source.getPackageName());
        this.cloneClassifier(source, outputInterface, cloneDocumentation);
        return outputInterface;
    }

    public ObjectModelEnumeration cloneEnumeration(ObjectModelEnumeration source, boolean cloneDocumentation) {
        ObjectModelEnumeration outputEnumeration = this.createEnumeration(source.getName(), source.getPackageName());
        this.cloneClassifier(source, outputEnumeration, cloneDocumentation);
        for (String literal : source.getLiterals()) {
            this.addLiteral(outputEnumeration, literal);
        }
        return outputEnumeration;
    }

    public ObjectModelClassifier cloneClassifier(ObjectModelClassifier source, boolean cloneDocumentation) {
        ObjectModelClassifier clone = null;
        if (source.isInterface()) {
            clone = this.cloneInterface((ObjectModelInterface)source, cloneDocumentation);
        } else if (source.isClass()) {
            clone = this.cloneClass((ObjectModelClass)source, cloneDocumentation);
        } else if (source.isEnum()) {
            clone = this.cloneEnumeration((ObjectModelEnumeration)source, cloneDocumentation);
        } else {
            log.error("strange classifier " + source);
        }
        return clone;
    }

    protected Set<String> addConstantsFromDependency(ObjectModelClassifier input, ObjectModelClassifier output) {
        Set<String> literals = this.eugeneTagValues.getConstants(input);
        if (literals == null) {
            ObjectModelDependency constantsDependencies = input.getDependency("constants");
            if (constantsDependencies == null) {
                return Collections.emptySet();
            }
            ObjectModelClassifier classifier = constantsDependencies.getSupplier();
            if (!(classifier instanceof ObjectModelEnumeration)) {
                return Collections.emptySet();
            }
            ObjectModelEnumeration constants = (ObjectModelEnumeration)classifier;
            literals = new HashSet<String>(constants.getLiterals());
            if (!literals.isEmpty()) {
                log.warn("");
                log.warn("Using constants dependencies is deprecated, use now tagValue *constants* instead.");
                log.warn("");
            }
        }
        LinkedHashSet<String> constantNames = new LinkedHashSet<String>();
        for (String literal : literals) {
            String constantName = this.getConstantName(literal);
            this.addConstant(output, constantName, String.class, "\"" + literal + "\"", (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
            constantNames.add(constantName);
        }
        return constantNames;
    }

    public String getConstantPrefix() {
        return this.constantPrefix;
    }

    public void setConstantPrefix(String constantPrefix) {
        this.constantPrefix = constantPrefix;
    }

    protected String getJavaBeanMethodName(String methodPrefix, String propertyName) {
        return methodPrefix + JavaGeneratorUtil.capitalizeJavaBeanPropertyName(propertyName);
    }

    protected String getJavaBeanMethodName(String methodPrefix, String propertyName, String methodSuffix) {
        return this.getJavaBeanMethodName(methodPrefix, propertyName) + methodSuffix;
    }

    public void initConstantPrefixFromModel() {
        this.constantPrefix = this.getConstantPrefix(null);
    }

    protected URL getFileInClassPath(String fqn) {
        String resourceName = fqn.replaceAll("\\.", "/") + ".java";
        URL fileLocation = this.getClassLoader().getResource(resourceName);
        if (log.isDebugEnabled()) {
            log.debug("Look for resource : " + resourceName + " = " + fileLocation);
        }
        return fileLocation;
    }

    protected void generateI18nBlock(ObjectModelClassifier input, ObjectModelClassifier output, String i18nPrefix) {
        ObjectModelOperation block = this.addBlock(output, ObjectModelJavaModifier.STATIC);
        StringBuilder buffer = new StringBuilder(300);
        this.addImport(output, I18n.class);
        this.addI18n(buffer, i18nPrefix, Introspector.decapitalize(input.getName()));
        for (ObjectModelAttribute attr : input.getAttributes()) {
            if (!attr.isNavigable()) continue;
            this.addI18n(buffer, i18nPrefix, Introspector.decapitalize(attr.getName()));
        }
        this.setOperationBody(block, buffer.toString());
    }

    protected void addI18n(StringBuilder buffer, String i18nPrefix, String suffix) {
        buffer.append("\n        I18n.n(\"");
        buffer.append(i18nPrefix);
        buffer.append(suffix);
        buffer.append("\");");
    }

    @Deprecated
    protected boolean isInClassPath(ObjectModelClassifier classifier) {
        return this.isInClassPath(classifier.getQualifiedName());
    }

    @Deprecated
    protected boolean isInClassPath(String fqn) {
        return this.getResourcesHelper().isJavaFileInClassPath(fqn);
    }

    @Deprecated
    protected boolean isInClassPath(String packageName, String className) {
        return this.isInClassPath(packageName + "." + className);
    }

    protected void storeServiceLoaderFile(Class<?> type, List<? extends ObjectModelClassifier> classes, Function<? super ObjectModelClassifier, String> function) {
        Path outputDirectory = this.getConfiguration().getProperty("resourceDirectory", File.class).toPath();
        boolean write = ServiceLoaderUtil.store(outputDirectory, type, this.toQualifiedNames(classes, function::apply));
        if (write) {
            this.getLog().info(String.format("Update service loader file (type %s) with %d classes.", type.getName(), classes.size()));
        } else if (this.isVerbose()) {
            this.getLog().info(String.format("Service loader file up to date (type %s) with %d classes.", type.getName(), classes.size()));
        }
    }

    protected List<String> toQualifiedNames(List<? extends ObjectModelClassifier> classes, Function<? super ObjectModelClassifier, String> function) {
        classes.sort(Comparator.comparing(ObjectModelClassifier::getQualifiedName));
        return classes.stream().map(function).collect(Collectors.toList());
    }

    protected String getMethodName(boolean useRelativeName, String[] relativeNameExcludes, String methodPrefix, String beanPackageName, String beanName) {
        if (beanPackageName != null) {
            beanName = beanPackageName + "." + (String)beanName;
        }
        String methodName = useRelativeName ? methodPrefix + Strings.getRelativeCamelCaseName((String)this.getDefaultPackageName(), (String)beanName, (String[])relativeNameExcludes) : methodPrefix + GeneratorUtil.getSimpleName((String)beanName);
        return methodName;
    }
}

