/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

public class JavaGeneratorUtil
extends GeneratorUtil {
    public static final String OPERATION_GETTER_DEFAULT_PREFIX = "get";
    public static final String OPERATION_GETTER_BOOLEAN_PREFIX = "is";
    public static final String DEPENDENCIES_CONSTANTS = "constants";

    public static void cloneOperations(ObjectModelTransformerToJava transformer, Iterable<ObjectModelOperation> operations, ObjectModelClassifier target, boolean useVisibility, ObjectModelModifier ... extraModifiers) {
        for (ObjectModelOperation op : operations) {
            ObjectModelModifier[] modifiers;
            if (useVisibility) {
                String visibility = op.getVisibility();
                ObjectModelJavaModifier modifier = ObjectModelJavaModifier.fromVisibility(visibility);
                int length = extraModifiers.length;
                if (length == 0) {
                    modifiers = new ObjectModelModifier[]{modifier};
                } else {
                    modifiers = new ObjectModelModifier[length + 1];
                    modifiers[0] = modifier;
                    System.arraycopy(extraModifiers, 0, modifiers, 1, length);
                }
            } else {
                modifiers = extraModifiers;
            }
            ObjectModelOperation resultOp = transformer.addOperation(target, op.getName(), op.getReturnType(), modifiers);
            for (ObjectModelParameter param : op.getParameters()) {
                transformer.addParameter(resultOp, param.getType(), param.getName());
            }
            for (String exception : op.getExceptions()) {
                transformer.addException(resultOp, exception);
            }
        }
    }

    public static String capitalizeJavaBeanPropertyName(String propertyName) {
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            return propertyName;
        }
        if (propertyName.length() == 1) {
            return propertyName.toUpperCase();
        }
        char c = propertyName.charAt(1);
        boolean carIsUp = Character.isUpperCase(c);
        if (carIsUp) {
            return propertyName;
        }
        return StringUtils.capitalize((String)propertyName);
    }

    public static String[] splitGeneric(String fqn) {
        if (fqn == null) {
            return null;
        }
        int firstPartIndex = fqn.indexOf(60);
        if (firstPartIndex == -1) {
            return new String[]{fqn};
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(fqn.substring(0, firstPartIndex));
        String rest = fqn.substring(firstPartIndex + 1, fqn.lastIndexOf(62));
        if (JavaGeneratorUtil.containsGenerics(rest) && rest.contains(",")) {
            int begin = 0;
            int count = 0;
            int max = rest.length();
            for (int i = 0; i < max; ++i) {
                char c = rest.charAt(i);
                if (c == '<') {
                    ++count;
                    continue;
                }
                if (c == '>') {
                    --count;
                    continue;
                }
                if (c != ',' || count != 0) continue;
                String part = rest.substring(begin, i);
                parts.add(part.trim());
                begin = i + 1;
            }
            if (begin < max) {
                String part = rest.substring(begin, max);
                parts.add(part.trim());
            }
        } else {
            String[] split;
            for (String part : split = rest.split(",")) {
                parts.add(part.trim());
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    public static String joinGeneric(String ... genericParts) {
        if (genericParts == null || genericParts.length == 0) {
            return null;
        }
        if (genericParts.length == 1) {
            return genericParts[0];
        }
        StringBuilder sb = new StringBuilder(genericParts[0]);
        sb.append("<").append(genericParts[1]);
        int max = genericParts.length;
        for (int i = 2; i < max; ++i) {
            String genericPart = genericParts[i];
            sb.append(", ").append(genericPart);
        }
        sb.append('>');
        return sb.toString();
    }

    public static boolean containsGenerics(String fqn) {
        return fqn.contains("<");
    }

    public static String[] splitFqnList(String fqns, char separator) {
        if (separator == '<' || separator == '>' || separator == ' ') {
            throw new IllegalArgumentException("Can not use '<' nor '>' for the separator");
        }
        if (fqns == null) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        int begin = 0;
        int count = 0;
        int max = fqns.length();
        for (int i = 0; i < max; ++i) {
            char c = fqns.charAt(i);
            if (c == '<') {
                ++count;
                continue;
            }
            if (c == '>') {
                --count;
                continue;
            }
            if (c != separator || count != 0) continue;
            String part = fqns.substring(begin, i);
            parts.add(part.trim());
            begin = i + 1;
        }
        if (begin < max) {
            String part = fqns.substring(begin, max);
            parts.add(part.trim());
        }
        return parts.toArray(new String[parts.size()]);
    }

    public static boolean isOrdered(ObjectModelAttribute attr) {
        return attr.isOrdered() || EugeneCoreTagValues.isOrdered(attr);
    }

    public static Class<?> getCollectionType(ObjectModelAttribute attr) {
        boolean ordered = JavaGeneratorUtil.isOrdered(attr);
        boolean unique = EugeneCoreTagValues.isUnique(attr);
        Class result = ordered ? (unique ? LinkedHashSet.class : List.class) : (unique ? Set.class : Collection.class);
        return result;
    }

    public static Class<?> getCollectionInstanceType(ObjectModelAttribute attr) {
        boolean ordered = JavaGeneratorUtil.isOrdered(attr);
        boolean unique = EugeneCoreTagValues.isUnique(attr);
        Class result = ordered ? (unique ? LinkedHashSet.class : LinkedList.class) : (unique ? HashSet.class : LinkedList.class);
        return result;
    }

    public static String getOperationParametersListDeclaration(ObjectModelOperation operation) {
        return Joiner.on((String)", ").join((Iterable)operation.getParameters().stream().map(param -> JavaGeneratorUtil.getAttributeInterfaceType(param) + " " + param.getName()).collect(Collectors.toList()));
    }

    public static String getClassAttributesListDeclaration(ObjectModelClass clazz) {
        StringBuilder result = new StringBuilder();
        Collection<ObjectModelAttribute> params = clazz.getAttributes();
        Iterator<ObjectModelAttribute> j = params.iterator();
        while (j.hasNext()) {
            ObjectModelAttribute attr = j.next();
            result.append(JavaGeneratorUtil.getAttributeInterfaceType(attr, true)).append(" ").append(attr.getName());
            if (!j.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String getAttributeInterfaceType(ObjectModelParameter attribute) {
        return JavaGeneratorUtil.getAttributeInterfaceType(attribute, false);
    }

    public static String getAttributeInterfaceType(ObjectModelParameter attribute, boolean useGenerics) {
        return JavaGeneratorUtil.getAttributeInterfaceType(attribute, attribute.getType(), useGenerics);
    }

    public static String getAttributeInterfaceType(ObjectModelParameter attribute, String attributeType, boolean useGenerics) {
        Object result;
        if (attribute instanceof ObjectModelAttribute && JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute)) {
            result = JavaGeneratorUtil.getCollectionType((ObjectModelAttribute)attribute).getName();
            if (useGenerics) {
                result = (String)result + "<" + attributeType + ">";
            }
        } else {
            result = attributeType;
        }
        return result;
    }

    public static String getAttributeImplementationType(ObjectModelParameter attribute, String attributeType, boolean useGenerics) {
        Object result;
        if (attribute instanceof ObjectModelAttribute && JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute)) {
            result = JavaGeneratorUtil.getCollectionInstanceType((ObjectModelAttribute)attribute).getName();
            if (useGenerics) {
                result = (String)result + "<" + attributeType + ">";
            }
        } else {
            result = attributeType;
        }
        return result;
    }

    public static String getAttributeImplementationType(ObjectModelParameter attribute, boolean useGenerics) {
        return JavaGeneratorUtil.getAttributeImplementationType(attribute, attribute.getType(), useGenerics);
    }

    public static String generateName(String prefix, String name, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            sb.append(prefix);
        }
        sb.append(name);
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

