/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.java.extension.AnnotationsManagerExtension;
import org.nuiton.eugene.java.extension.ImportsManagerExtension;
import org.nuiton.eugene.java.extension.ObjectModelAnnotation;
import org.nuiton.eugene.java.extension.ObjectModelAnnotationParameter;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

@Component(role=Template.class, hint="org.nuiton.eugene.java.JavaGenerator")
public class JavaGenerator
extends ObjectModelGenerator {
    private static final Logger log = LogManager.getLogger(JavaGenerator.class);
    protected int innerLevel;
    protected String prefix;

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return this.getFilenameForClassifier(clazz);
    }

    @Override
    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return this.getFilenameForClassifier(interfacez);
    }

    @Override
    public String getFilenameForEnumeration(ObjectModelEnumeration enumeration) {
        return this.getFilenameForClassifier(enumeration);
    }

    @Override
    public String getFilenameForClassifier(ObjectModelClassifier clazz) {
        String s = clazz.getQualifiedName();
        int index = s.indexOf("<");
        if (index > -1) {
            s = s.substring(0, index);
        }
        return s.replace('.', File.separatorChar) + ".java";
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass input) throws IOException {
        if (this.isVerbose()) {
            log.info("Will generate class " + input.getQualifiedName());
        }
        this.preparePrefix(input);
        this.generateHeader(output, input);
        String abstractStr = input.isAbstract() ? " abstract" : "";
        String staticStr = input.isStatic() ? " static" : "";
        String className = input.getName();
        String intpuName = input.getName();
        Object extend = "";
        Iterator<ObjectModelClass> j = input.getSuperclasses().iterator();
        if (j.hasNext()) {
            ObjectModelClassifier p = j.next();
            String simpleName = GeneratorUtil.getSimpleName(p.getQualifiedName());
            if (GeneratorUtil.simpleNamesEquals(intpuName, simpleName)) {
                simpleName = p.getQualifiedName();
            }
            extend = (String)extend + simpleName;
        }
        Object implement = "";
        Iterator<ObjectModelInterface> i = input.getInterfaces().iterator();
        while (i.hasNext()) {
            ObjectModelClassifier parentInterface = i.next();
            String interfaceName = GeneratorUtil.getSimpleName(parentInterface.getQualifiedName());
            if (GeneratorUtil.simpleNamesEquals(intpuName, interfaceName)) {
                interfaceName = parentInterface.getQualifiedName();
            }
            implement = (String)implement + interfaceName;
            if (!i.hasNext()) continue;
            implement = (String)implement + ", ";
        }
        if (log.isDebugEnabled()) {
            log.debug(className + " : super : " + (String)extend + ", interfaces : " + (String)implement);
        }
        this.generateAnnotations(output, input, input);
        output.write(this.prefix + "public" + staticStr + abstractStr + " class " + className);
        if (((String)extend).length() > 0) {
            output.write(" extends " + (String)extend);
        }
        if (((String)implement).length() > 0) {
            output.write(" implements " + (String)implement);
        }
        output.write(" {\n");
        output.write("");
        this.generateInnerClassifiers(output, input.getInnerClassifiers());
        this.preparePrefix(input);
        this.generateAttributes(output, input, input.getAttributes());
        this.generateOperations(output, input, input.getOperations());
        output.write(this.prefix + "} //" + className + "\n");
        output.write("");
    }

    @Override
    public void generateFromInterface(Writer output, ObjectModelInterface input) throws IOException {
        if (this.isVerbose()) {
            log.info("Will generate interface " + input.getQualifiedName());
        }
        this.preparePrefix(input);
        this.generateHeader(output, input);
        String interfaceName = input.getName();
        Object extend = "";
        Iterator<ObjectModelInterface> j = input.getInterfaces().iterator();
        while (j.hasNext()) {
            ObjectModelClassifier p = j.next();
            String simpleName = GeneratorUtil.getSimpleName(p.getQualifiedName());
            if (GeneratorUtil.simpleNamesEquals(interfaceName, simpleName)) {
                simpleName = p.getQualifiedName();
            }
            extend = (String)extend + simpleName;
            if (!j.hasNext()) continue;
            extend = (String)extend + ", ";
        }
        this.generateAnnotations(output, input, input);
        output.write(this.prefix + "public interface " + interfaceName);
        if (((String)extend).length() > 0) {
            output.write(" extends " + (String)extend);
        }
        output.write(" {\n");
        output.write("");
        this.generateAttributes(output, input, input.getAttributes());
        this.generateOperations(output, input, input.getOperations());
        output.write(this.prefix + "} //" + interfaceName + "\n");
        output.write("");
    }

    public void generateAnnotations(Writer output, ObjectModelClassifier clazz, ObjectModelElement element) throws IOException {
        AnnotationsManagerExtension managers = ((ObjectModel)this.getModel()).getExtension("annotations", AnnotationsManagerExtension.class);
        List<ObjectModelAnnotation> annotations = managers.getAnnotations(clazz, element);
        for (ObjectModelAnnotation annotation : annotations) {
            StringBuilder annotationBuilder = new StringBuilder("@" + annotation.getType());
            List<ObjectModelAnnotationParameter> annotationParameters = annotation.getParameters();
            if (CollectionUtils.isNotEmpty(annotationParameters)) {
                annotationBuilder.append('(');
                ArrayList params = Lists.newArrayList();
                for (ObjectModelAnnotationParameter annotationParameter : annotationParameters) {
                    String paramStr = annotationParameter.getName() + " = ";
                    Object value = annotationParameter.getValue();
                    if (value instanceof String) {
                        paramStr = ((String)value).startsWith("{") ? paramStr + value : paramStr + "\"" + value + "\"";
                    } else if (value instanceof Enum) {
                        Enum anEnum = (Enum)value;
                        paramStr = paramStr + anEnum.getClass().getSimpleName() + "." + value;
                    } else {
                        paramStr = paramStr + value.toString();
                    }
                    params.add(paramStr);
                }
                Joiner.on((String)", ").appendTo(annotationBuilder, (Iterable)params);
                annotationBuilder.append(')');
            }
            Object annotationStr = annotationBuilder.toString();
            if (element instanceof ObjectModelOperation || element instanceof ObjectModelAttribute) {
                output.write(this.prefix);
                annotationStr = "    " + (String)annotationStr;
            }
            output.write((String)annotationStr);
            if (!(element instanceof ObjectModelClassifier) && !(element instanceof ObjectModelOperation) && !(element instanceof ObjectModelAttribute)) continue;
            output.write("\n");
            output.write("");
        }
    }

    @Override
    public void generateFromEnumeration(Writer output, ObjectModelEnumeration input) throws IOException {
        this.generateFromEnum(output, input);
    }

    @Override
    public void generateFromEnum(Writer output, ObjectModelEnumeration input) throws IOException {
        if (this.isVerbose()) {
            log.info("Will generate enumeration " + input.getQualifiedName());
        }
        this.preparePrefix(input);
        this.generateHeader(output, input);
        String enumzName = input.getName();
        Object extend = "";
        Iterator<ObjectModelInterface> j = input.getInterfaces().iterator();
        if (j.hasNext()) {
            ObjectModelClassifier p = j.next();
            extend = (String)extend + GeneratorUtil.getSimpleName(p.getQualifiedName());
        }
        this.generateAnnotations(output, input, input);
        output.write("\n");
        output.write(this.prefix + "public enum " + enumzName);
        if (((String)extend).length() > 0) {
            output.write(" implements " + (String)extend + " {\n");
            output.write("");
        } else {
            output.write(" {\n");
            output.write("");
        }
        if (input.getLiterals().isEmpty()) {
            output.write(" ; ");
        } else {
            Iterator<String> i = input.getLiterals().iterator();
            while (i.hasNext()) {
                String literal = i.next();
                output.write(this.prefix + "    " + literal + (i.hasNext() ? "," : ";") + "\n");
                output.write("");
            }
        }
        this.generateAttributes(output, input, input.getAttributes());
        this.generateOperations(output, input, input.getOperations());
        output.write(this.prefix + "} //" + enumzName + "\n");
        output.write("");
    }

    public void generateInnerClassifiers(Writer output, Collection<ObjectModelClassifier> innerClassifiers) throws IOException {
        if (innerClassifiers == null || innerClassifiers.isEmpty()) {
            return;
        }
        for (ObjectModelClassifier innerClassifier : innerClassifiers) {
            if (innerClassifier.isClass()) {
                this.generateFromClass(output, (ObjectModelClass)innerClassifier);
                --this.innerLevel;
                continue;
            }
            if (innerClassifier.isInterface()) {
                this.generateFromInterface(output, (ObjectModelInterface)innerClassifier);
                --this.innerLevel;
                continue;
            }
            if (!innerClassifier.isEnum()) continue;
            this.generateFromEnum(output, (ObjectModelEnumeration)innerClassifier);
            --this.innerLevel;
        }
    }

    protected void preparePrefix(ObjectModelClassifier clazz) {
        if (!clazz.isInner()) {
            this.innerLevel = 0;
            this.prefix = "";
        } else {
            ++this.innerLevel;
            char[] tmp = new char[this.innerLevel * 4];
            Arrays.fill(tmp, ' ');
            this.prefix = new String(tmp);
        }
        if (log.isDebugEnabled()) {
            log.debug("prefix to use for classifier " + clazz.getName() + " : [" + this.prefix + "]");
        }
    }

    protected void generateHeader(Writer output, ObjectModelClassifier classifier) throws IOException {
        if (classifier.isInner()) {
            return;
        }
        String packageName = classifier.getPackageName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ImportsManagerExtension managers = ((ObjectModel)this.getModel()).getExtension("imports", ImportsManagerExtension.class);
        List<String> imports = managers.getImports(classifier);
        for (String singleImport : imports) {
            output.write("import " + singleImport + ";\n");
            output.write("");
        }
        if (CollectionUtils.isNotEmpty(imports)) {
            output.write("\n");
            output.write("");
        }
    }

    protected void generateAttributes(Writer output, ObjectModelClassifier clazz, Collection<ObjectModelAttribute> attributes) throws IOException {
        for (ObjectModelAttribute attr : attributes) {
            String attrTransient;
            output.write("\n");
            output.write("");
            String documentation = attr.getDocumentation();
            if (StringUtils.isNotEmpty((CharSequence)documentation)) {
                String[] lines;
                output.write(this.prefix + "    /**\n");
                output.write("");
                for (String line : lines = documentation.split("\n")) {
                    output.write(this.prefix + "     * " + line + "\n");
                    output.write("");
                }
                output.write(this.prefix + "     */\n");
                output.write("");
            }
            this.generateAnnotations(output, clazz, attr);
            String attrName = attr.getName();
            Object attrVisibility = attr.getVisibility();
            String attrType = attr.getType();
            String attrStatic = attr.isStatic() ? "static " : "";
            String attrFinal = attr.isFinal() ? "final " : "";
            String string = attrTransient = attr.isTransient() ? "transient " : "";
            if (clazz instanceof ObjectModelInterface) {
                attrStatic = "";
                attrFinal = "";
                attrTransient = "";
                attrVisibility = "";
            }
            if (StringUtils.isNotEmpty((CharSequence)attrVisibility)) {
                attrVisibility = (String)attrVisibility + " ";
            }
            String attrValue = StringUtils.isNotEmpty((CharSequence)attr.getDefaultValue()) ? " = " + attr.getDefaultValue() : "";
            output.write(this.prefix + "    " + (String)attrVisibility + attrStatic + attrFinal + attrTransient + attrType + " " + attrName + attrValue + ";\n");
            output.write("");
        }
    }

    protected void generateOperations(Writer output, ObjectModelClassifier clazz, Collection<ObjectModelOperation> operations) throws IOException {
        if (!operations.isEmpty()) {
            output.write("\n");
            output.write("");
        }
        boolean interfacez = ObjectModelInterface.class.isAssignableFrom(clazz.getClass());
        for (ObjectModelOperation op : operations) {
            boolean bl;
            String opName = op.getName();
            if (opName == null) {
                this.generateBlock(output, clazz, op);
                continue;
            }
            this.generateOperationDocumentation(output, op);
            this.generateAnnotations(output, clazz, op);
            Object opVisibility = !interfacez ? op.getVisibility() : "";
            String opStatic = op.isStatic() ? "static " : "";
            String opAbstract = op.isAbstract() ? "abstract " : "";
            String opDefault = op.isDefault() ? "default " : "";
            String opFinal = op.isFinal() ? "final " : "";
            ObjectModelParameter returnParam = op.getReturnParameter();
            Object opReturn = "";
            if (returnParam != null) {
                opReturn = returnParam.getType() + " ";
            }
            if (StringUtils.isNotEmpty((CharSequence)opVisibility)) {
                opVisibility = (String)opVisibility + " ";
            }
            output.write(this.prefix + "    " + opDefault + (String)opVisibility + opStatic + opFinal + opAbstract + (String)opReturn + opName + "(");
            String comma = "";
            Collection<ObjectModelParameter> params = op.getParameters();
            for (ObjectModelParameter objectModelParameter : params) {
                String paramName = objectModelParameter.getName();
                String paramType = objectModelParameter.getType();
                output.write(comma + paramType + " " + paramName);
                comma = ", ";
            }
            output.write(")");
            comma = " throws ";
            Set<String> exceptions = op.getExceptions();
            for (String exception : exceptions) {
                String exceptionName = GeneratorUtil.getSimpleName(exception);
                output.write(comma + exceptionName);
                comma = ", ";
            }
            boolean bl2 = interfacez ? op.isDefault() || op.isStatic() : (bl = !op.isAbstract());
            if (bl) {
                String body = op.getBodyCode() == null ? "" : op.getBodyCode();
                output.write(this.prefix + " {" + body + this.prefix + "}\n");
                output.write("\n");
                output.write("");
                continue;
            }
            output.write(";\n");
            output.write("\n");
            output.write("");
        }
    }

    protected void generateOperationDocumentation(Writer output, ObjectModelOperation op) throws IOException {
        String[] documentationLines;
        String documentation = op.getDocumentation();
        if (StringUtils.isEmpty((CharSequence)documentation)) {
            return;
        }
        output.write(this.prefix + "    /**\n");
        output.write(this.prefix);
        for (String documentationLine : documentationLines = documentation.split("\n")) {
            output.write(this.prefix + "     * " + documentationLine + "\n");
            output.write("");
        }
        Collection<ObjectModelParameter> params = op.getParameters();
        for (ObjectModelParameter param : params) {
            String paramName = param.getName();
            String paramDocumentation = param.getDocumentation();
            if (paramDocumentation == null) {
                paramDocumentation = "";
            }
            output.write(this.prefix + "     * @param " + paramName + " " + paramDocumentation + "\n");
            output.write("");
        }
        ObjectModelParameter returnParam = op.getReturnParameter();
        Object opReturn = "";
        if (returnParam != null && !((String)(opReturn = GeneratorUtil.getSimpleName(returnParam.getType()) + " ")).contains("void")) {
            String paramDocumentation = returnParam.getDocumentation();
            if (paramDocumentation == null) {
                paramDocumentation = "";
            }
            output.write(this.prefix + "     * @return " + paramDocumentation + "\n");
            output.write("");
        }
        Set<String> exceptions = op.getExceptions();
        for (String exception : exceptions) {
            String exceptionName = GeneratorUtil.getSimpleName(exception);
            output.write(this.prefix + "     * @throws " + exceptionName + "\n");
            output.write("");
        }
        output.write(this.prefix + "     */\n");
        output.write("");
    }

    protected void generateBlock(Writer output, ObjectModelClassifier clazz, ObjectModelOperation op) throws IOException {
        String opStatic = op.isStatic() ? "static " : " ";
        output.write(this.prefix + "    " + opStatic + "{\n");
        output.write(this.prefix + "    " + op.getBodyCode() + "\n");
        output.write(this.prefix + "    }\n");
        output.write("\n");
        output.write("");
    }
}

