/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.DefaultTemplateConfiguration;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;

public abstract class Transformer<I extends Model, O extends Model>
extends Template<I> {
    private static final Logger log = LogManager.getLogger(Transformer.class);
    protected Template<O> outputTemplate;
    protected Transformer<I, I> previousTransformer;
    protected O outputModel;
    protected Properties outputProperties = new Properties();

    protected void init(I model) {
        this.model = model;
        this.resourcesHelper = null;
        this.outputTemplate = this.initOutputTemplate();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getConfiguration().getProperties());
        properties.putAll((Map<?, ?>)this.outputProperties);
        DefaultTemplateConfiguration outconfig = new DefaultTemplateConfiguration(properties);
        this.outputTemplate.setConfiguration(outconfig);
        this.outputModel = this.initOutputModel();
    }

    protected Transformer<I, I> initPreviousTransformer() {
        return null;
    }

    protected abstract Template<O> initOutputTemplate();

    protected abstract O initOutputModel();

    @Deprecated
    protected Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void addOutputProperty(String key, Object value) {
        this.outputProperties.put(key, value);
    }

    public Template<O> getOutputTemplate() {
        return this.outputTemplate;
    }

    public O getOutputModel() {
        return this.outputModel;
    }

    public String getDefaultPackageName() {
        String packageName = this.getConfiguration().getProperty("defaultPackage");
        return packageName;
    }

    @Override
    public void applyTemplate(I model, File destDir) throws IOException {
        this.previousTransformer = this.initPreviousTransformer();
        if (this.previousTransformer != null) {
            if (this.isVerbose()) {
                log.info("Use previousTransformer " + this.previousTransformer);
            }
            this.previousTransformer.transform(model);
            this.transform(this.previousTransformer.getOutputModel());
        } else {
            this.transform(model);
        }
        this.getOutputTemplate().applyTemplate(this.getOutputModel(), destDir);
    }

    public void transform(I model) {
        this.init(model);
        this.transform();
    }

    protected abstract void transform();
}

