/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcesHelper {
    private static final Logger log = LogManager.getLogger(ResourcesHelper.class);
    protected final ClassLoader classLoader;
    protected final File outputDirectory;
    protected final boolean verbose;

    public ResourcesHelper(ClassLoader classLoader, File outputDirectory, boolean verbose) {
        this.classLoader = classLoader;
        this.outputDirectory = outputDirectory;
        this.verbose = verbose;
    }

    public boolean isJavaFileInOutputDirectory(String fqn) {
        URL fileLocation = this.getFileInOutputDirectory(fqn, "\\.", ".java");
        return fileLocation != null;
    }

    public boolean isJavaFileInClassPath(String fqn) {
        return this.isFullyQualifiedNameInClassPath(fqn, ".java");
    }

    public boolean isFullyQualifiedNameInClassPath(String fqn, String extension) {
        return this.isInClassPath(fqn, "\\.", extension);
    }

    public boolean isInClassPath(String fqn, String pathSeparator, String extension) {
        URL classLocation;
        URL fileLocation = this.getFileInClassPath(fqn, pathSeparator, extension);
        if (fileLocation != null) {
            if (log.isDebugEnabled()) {
                log.debug("Will not generate [" + fqn + "], already found in class-path at location : " + fileLocation);
            } else if (this.verbose) {
                log.info("Will not generate [" + fqn + "], already found in class-path.");
            }
            return true;
        }
        if (".java".equals(extension) && (classLocation = this.getFileInClassPath(fqn, pathSeparator, ".class")) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Will not generate [" + fqn + "], already found in class-path at location : " + classLocation);
            } else if (this.verbose) {
                log.info("Will not generate [" + fqn + "], already found in class-path.");
            }
            return true;
        }
        return false;
    }

    protected URL getFileInClassPath(String fqn, String pathSeparator, String extension) {
        String resourceName = fqn.replaceAll(pathSeparator, "/") + extension;
        URL fileLocation = this.classLoader.getResource(resourceName);
        if (log.isDebugEnabled()) {
            log.debug("Look for resource : " + resourceName + " = " + fileLocation);
        }
        return fileLocation;
    }

    protected URL getFileInOutputDirectory(String fqn, String pathSeparator, String extension) {
        String resourceName = fqn.replaceAll(pathSeparator, File.separator) + extension;
        File fileLocation = new File(this.outputDirectory, resourceName);
        if (!fileLocation.exists()) {
            return null;
        }
        try {
            return fileLocation.toURI().toURL();
        }
        catch (MalformedURLException ignored) {
            return null;
        }
    }
}

