/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import io.ultreia.java4all.lang.ClassLoaders;
import io.ultreia.java4all.lang.Strings;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceResolver
implements URIResolver {
    public static final Pattern HREF_PATTERN = Pattern.compile("([a-zA-Z]+)\\:\\/\\/(.+)");
    protected static final SortedMap<String, Source> sourceCache = new TreeMap<String, Source>();
    protected static final Set<String> unresolvedCache = new HashSet<String>();
    private static final Logger log = LogManager.getLogger(ResourceResolver.class);
    protected String base;
    protected boolean verbose = log.isDebugEnabled();
    protected ClassLoader cl = this.getClass().getClassLoader();

    public ResourceResolver() {
        this(null);
    }

    public ResourceResolver(String base) {
        if (base != null && base.endsWith("/") && base.length() > 1) {
            base = base.substring(0, base.length() - 1);
        }
        this.base = base;
        if (log.isTraceEnabled()) {
            log.trace(this + ", base : " + this.base);
        }
    }

    public static synchronized void clearCache() {
        sourceCache.clear();
        unresolvedCache.clear();
    }

    @Override
    public synchronized Source resolve(String href, String base) {
        Source source;
        Matcher matcher;
        if (unresolvedCache.contains(href)) {
            if (this.verbose) {
                log.info("Skip unresolved " + href);
            }
            return null;
        }
        if (sourceCache.containsKey(href)) {
            if (this.verbose) {
                log.info("use cached source " + href);
            }
            return (Source)sourceCache.get(href);
        }
        if (this.verbose) {
            log.info("Resolving " + href);
        }
        if ((matcher = HREF_PATTERN.matcher(href)).matches()) {
            String path = matcher.group(2);
            source = this.findHrefSource(path);
        } else {
            source = this.findRelativeSource(href);
        }
        if (source == null) {
            if (this.verbose) {
                log.info("detect unresolved source " + href);
            }
            unresolvedCache.add(href);
        } else {
            if (this.verbose) {
                log.info("detect cacheable  source " + href);
            }
            sourceCache.put(href, source);
        }
        return source;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setCl(ClassLoader cl) {
        this.cl = cl;
    }

    protected Source findHrefSource(String path) {
        ClassLoader cl32;
        long t0 = System.nanoTime();
        int beginIndex = path.lastIndexOf(47);
        String filename = beginIndex > -1 ? path.substring(beginIndex + 1) : path;
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        String resource = ".*/" + filename;
        if (this.verbose) {
            log.info("will discover " + resource);
        }
        URL url = null;
        List urls = null;
        URLClassLoader ucl = null;
        if (this.cl == null && (cl32 = this.getClass().getClassLoader()) instanceof URLClassLoader) {
            ucl = (URLClassLoader)cl32;
        }
        if (this.cl instanceof URLClassLoader) {
            ucl = (URLClassLoader)this.cl;
        }
        try {
            urls = ClassLoaders.getURLs((String)resource, (URLClassLoader)ucl);
        }
        catch (Exception cl32) {
            // empty catch block
        }
        if (urls != null && !urls.isEmpty()) {
            url = (URL)urls.get(0);
        }
        StreamSource source = null;
        if (url != null) {
            if (this.verbose) {
                log.info(url.toString());
            }
            source = new StreamSource(url.toString());
        }
        if (this.verbose) {
            String time = Strings.convertTime((long)(System.nanoTime() - t0));
            log.info("resolved in " + time);
        }
        return source;
    }

    protected Source findRelativeSource(String path) {
        long t0 = System.nanoTime();
        String filename = path;
        Object resource = this.base != null ? this.base + "/" + filename : filename;
        if (this.verbose) {
            log.info("will discover " + (String)resource);
        }
        URL url = ClassLoaders.getURLOrNull((String)resource);
        StreamSource source = null;
        if (url != null) {
            if (this.verbose) {
                log.info(url.toString());
            }
            source = new StreamSource(url.toString());
        }
        if (this.verbose) {
            String time = Strings.convertTime((long)(System.nanoTime() - t0));
            log.info("resolved in " + time);
        }
        return source;
    }
}

