/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene;

import java.util.Map;
import java.util.Properties;
import org.nuiton.eugene.TemplateConfiguration;
import org.nuiton.eugene.writer.WriterReport;

public class DefaultTemplateConfiguration
implements TemplateConfiguration {
    public static final String DEFAULT_ENCONDING = "UTF-8";
    protected Properties properties;

    public DefaultTemplateConfiguration() {
    }

    public DefaultTemplateConfiguration(Properties properties) {
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public boolean isOverwrite() {
        Boolean value = this.getProperty("overwrite", Boolean.class);
        if (value == null) {
            value = true;
            this.setProperty("overwrite", value);
        }
        return value;
    }

    @Override
    public boolean isVerbose() {
        Boolean value = this.getProperty("verbose", Boolean.class);
        if (value == null) {
            value = false;
            this.setProperty("verbose", value);
        }
        return value;
    }

    @Override
    public String getEncoding() {
        String value = this.getProperty("encoding", String.class);
        if (value == null) {
            value = DEFAULT_ENCONDING;
            this.setProperty("encoding", value);
        }
        return value;
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader value = this.getProperty("classLoader", ClassLoader.class);
        if (value == null) {
            value = this.getClass().getClassLoader();
            this.setProperty("classLoader", value);
        }
        return value;
    }

    @Override
    public WriterReport getWriterReport() {
        WriterReport report = this.getProperty("writerReport", WriterReport.class);
        return report;
    }

    @Override
    public long getLastModifiedSource() {
        Long value = this.getProperty("lastModifiedSource", Long.class);
        if (value == null) {
            value = 0L;
            this.setProperty("lastModifiedSource", value);
        }
        return value;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, String.class);
    }

    @Override
    public <V> V getProperty(String key, Class<V> type) {
        Object o = this.getProperties().get(key);
        if (o != null && !type.isAssignableFrom(type)) {
            throw new IllegalArgumentException("property [" + key + "] is not of type " + type.getName() + ", but : " + o.getClass().getName());
        }
        return (V)o;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.getProperties().put(key, value);
    }

    public void setOverwrite(boolean overwrite) {
        this.setProperty("overwrite", overwrite);
    }

    public void setVerbose(boolean verbose) {
        this.setProperty("verbose", verbose);
    }

    public void setEncoding(String encoding) {
        this.setProperty("encoding", encoding);
    }

    public void setLoader(ClassLoader loader) {
        this.setProperty("classLoader", loader);
    }

    public void setLastModifiedSource(long lastModifiedSource) {
        this.setProperty("lastModifiedSource", lastModifiedSource);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

