/*
 * #%L
 * EUGene :: EUGene Core
 * %%
 * Copyright (C) 2004 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.eugene.models.state;

import java.util.Collection;

/**
 * StateModelComplexeState
 *
 * Represents a complex state that can be composed with a set of states.
 *
 * @author chatellier
 */
public interface StateModelComplexState extends StateModelState {

    /**
     * Return the states set
     *
     * @return a collection of states
     */
    Collection<StateModelState> getStates();

    /**
     * Return the non initial state pointed by the initial state of the state
     * set.
     *
     * Exemple :
     * myComplexeState = (
     * init1 -&gt; state2 -&gt; state3 -&gt; final4
     * )
     *
     * myComplexeState.getInitialState() will return state2.
     *
     * @return a state
     */
    StateModelState getInitialState();
}
