package org.nuiton.eugene.models.extension.io;

/*-
 * #%L
 * EUGene :: EUGene Core
 * %%
 * Copyright (C) 2004 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.eugene.models.extension.model.ModelExtension;
import org.nuiton.eugene.models.extension.model.ModelExtensionAttribute;
import org.nuiton.eugene.models.extension.model.ModelExtensionClass;
import org.nuiton.eugene.models.extension.model.ModelExtensionPackage;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelPackage;

/**
 * Created on 08/10/16.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 3.0
 */
class ModelExtensionWriterPropertiesImpl extends ModelExtensionWriter {

    private final String eol = System.lineSeparator();

    @Override
    public void write(ObjectModel modelBean, Writer writer) throws IOException {

        writer.append("# Generated by ").append(this.getClass().getName()).append(" at ").append(new Date().toString()).append(eol);

        appendMap(modelBean.getTagValues(), "model.tagValue.", writer);
        appendSet(modelBean.getStereotypes(), "model.stereotype", writer);

        if (CollectionUtils.isNotEmpty(modelBean.getPackages())) {

            for (ObjectModelPackage packageBean : modelBean.getPackages()) {

                appendMap(packageBean.getTagValues(), "package.tagValue.", writer);
                appendSet(packageBean.getStereotypes(), "package.stereotype", writer);

            }

        }

        if (CollectionUtils.isNotEmpty(modelBean.getClasses())) {

            for (ObjectModelClass classBean : modelBean.getClasses()) {

                String prefix = classBean.getQualifiedName() + ".class.";
                appendMap(classBean.getTagValues(), prefix + "tagValue.", writer);
                appendSet(classBean.getStereotypes(), prefix + "stereotype", writer);

                for (ObjectModelAttribute attributeBean : classBean.getAttributes()) {

                    prefix = classBean.getQualifiedName() + ".attribute." + attributeBean.getName() + ".";
                    appendMap(attributeBean.getTagValues(), prefix + "tagValue.", writer);
                    appendSet(attributeBean.getStereotypes(), prefix + "stereotype", writer);
                }

            }

        }

    }

    @Override
    public void write(ModelExtension model, Writer writer) throws IOException {


        writer.append("# Generated by ").append(this.getClass().getName()).append(" at ").append(new Date().toString()).append(eol);

        appendMap(model.getTagValues(), "model.tagValue.", writer);
        appendSet(model.getStereotypes(), "model.stereotype", writer);

        if (CollectionUtils.isNotEmpty(model.getPackages())) {

            for (ModelExtensionPackage packageBean : model.getPackages()) {
                String prefix = "package." + packageBean.getName() + ".";

                appendMap(packageBean.getTagValues(), prefix + "tagValue.", writer);
                appendSet(packageBean.getStereotypes(), prefix + "stereotype", writer);

            }

        }

        if (CollectionUtils.isNotEmpty(model.getClasses())) {

            for (ModelExtensionClass classBean : model.getClasses()) {

                String prefix = classBean.getName() + ".class.";
                appendMap(classBean.getTagValues(), prefix + "tagValue.", writer);
                appendSet(classBean.getStereotypes(), prefix + "stereotype", writer);

                for (ModelExtensionAttribute attributeBean : classBean.getAttributes()) {
                    prefix = classBean.getName() + ".attribute." + attributeBean.getName() + ".";
                    appendMap(attributeBean.getTagValues(), prefix + "tagValue.", writer);
                    appendSet(attributeBean.getStereotypes(), prefix + "stereotype", writer);
                }

            }

        }

    }

    private void appendMap(Map<String, String> map, String prefix, Writer writer) throws IOException {
        if (!map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!"true".equals(entry.getValue())) {
                    writer.append(prefix).append(entry.getKey()).append("=").append(entry.getValue()).append(eol);
                }
            }
        }
    }

    private void appendSet(Set<String> set, String prefix, Writer writer) throws IOException {
        if (!set.isEmpty()) {
            writer.append(prefix).append("=").append(Joiner.on(",").join(set)).append(eol);
        }
    }
}
