package org.nuiton.eugene.models.extension.io;

/*-
 * #%L
 * EUGene :: EUGene Core
 * %%
 * Copyright (C) 2004 - 2017 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.eugene.models.object.ObjectModel;

/**
 * Created on 09/09/16.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 3.0
 */
public interface ModelExtensionFileParserCallback {

    boolean onModelTagValueFound(String tag, String value);

    boolean onModelStereotypeFound(String stereotype);

    boolean onPackageTagValueFound(String packageName, String tag, String value);

    boolean onPackageStereotypeFound(String packageName, String stereotype);

    boolean onClassTagValueFound(String className, String tag, String value);

    boolean onClassStereotypeFound(String className, String stereotype);

    boolean onAttributeTagValueFound(String className, String attributeName, String tag, String value);

    boolean onAttributeStereotypeFound(String className, String attributeName, String stereotype);

}
