package io.ultreia.java4all.config.io.runtime;

/*-
 * #%L
 * Config :: IO Properties
 * %%
 * Copyright (C) 2016 - 2018 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.auto.service.AutoService;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;

/**
 * Created on 07/10/16.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 3.1
 */
@AutoService(ApplicationConfigReader.class)
public class ApplicationConfigReaderProperties implements ApplicationConfigReader {
    @Override
    public String getFormat() {
        return "properties";
    }

    @Override
    public Properties readProperties(URL url, String encoding) throws ApplicationConfigReaderException {
        Properties properties = new Properties();
        try (Reader reader = new BufferedReader(new InputStreamReader(url.openStream(), encoding))) {
            properties.load(reader);
        } catch (Exception e) {
            throw new ApplicationConfigReaderException("Can't read properties file: " + url, e);
        }
        return properties;
    }

}
