/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.config.clean;

import io.ultreia.java4all.config.clean.CleanTemporaryFilesTaskConfiguration;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanTemporaryFilesTask
extends TimerTask {
    private static final Logger log = LogManager.getLogger(CleanTemporaryFilesTask.class);
    private final CleanTemporaryFilesTaskConfiguration configuration;

    public static Timer create(CleanTemporaryFilesTaskConfiguration configuration) {
        Timer result = new Timer("Delete temporary files daemon", true);
        result.scheduleAtFixedRate((TimerTask)new CleanTemporaryFilesTask(configuration), new Date(), TimeUnit.HOURS.toMillis(1L));
        return result;
    }

    private static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    public CleanTemporaryFilesTask(CleanTemporaryFilesTaskConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void run() {
        this.configuration.getTemporaryDirectoriesAndTimeout().forEach(this::run);
    }

    private void run(Path temporaryDirectory, Integer timeout) {
        if (Files.notExists(temporaryDirectory, new LinkOption[0])) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(11, -timeout.intValue());
        Date deleteBefore = calendar.getTime();
        long deleteBeforeTime = deleteBefore.getTime();
        log.info(String.format("Delete temporary files in directory %s before %s", temporaryDirectory, deleteBefore));
        this.delete(temporaryDirectory, deleteBeforeTime);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean delete(Path path, long deleteBeforeTime) {
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            walk.forEach(p -> {
                boolean deleted;
                if (Objects.equals(path, p)) {
                    return;
                }
                if (Files.isDirectory(p, new LinkOption[0]) && (deleted = this.delete((Path)p, deleteBeforeTime))) {
                    this.delete0((Path)p, deleteBeforeTime);
                }
                if (Files.isRegularFile(p, new LinkOption[0])) {
                    this.delete0((Path)p, deleteBeforeTime);
                }
            });
            if (Files.isRegularFile(path, new LinkOption[0])) {
                boolean bl = Files.notExists(path, new LinkOption[0]);
                return bl;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                boolean bl = CleanTemporaryFilesTask.isDirEmpty(path);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not walk through temporary directory: %s", path), e);
        }
    }

    private void delete0(Path p, long deleteBeforeTime) {
        try {
            if (Files.getLastModifiedTime(p, new LinkOption[0]).toMillis() < deleteBeforeTime) {
                log.info("Delete temporary file: " + p);
                Files.delete(p);
            }
        }
        catch (IOException e) {
            log.error("Something wrong while process file: " + p, (Throwable)e);
        }
    }
}

