/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.config;

import io.ultreia.java4all.config.ApplicationConfig;
import io.ultreia.java4all.config.ConfigResource;
import io.ultreia.java4all.config.spi.ApplicationConfigInit;
import io.ultreia.java4all.config.spi.ConfigOptionDef;
import io.ultreia.java4all.util.Zips;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GeneratedConfigSupport<O extends ConfigOptionDef>
implements Supplier<ApplicationConfig> {
    private static final Logger log = LogManager.getLogger(GeneratedConfigSupport.class);
    protected final ApplicationConfig applicationConfig;

    protected GeneratedConfigSupport(String fileName) {
        this(ApplicationConfigInit.defaultInit().setConfigFileName(fileName));
    }

    protected GeneratedConfigSupport(ApplicationConfigInit init) {
        this.applicationConfig = this.createApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions(this.options());
    }

    protected ApplicationConfig createApplicationConfig(ApplicationConfigInit init) {
        return new ApplicationConfig(init);
    }

    protected abstract O[] options();

    @Override
    public final ApplicationConfig get() {
        return this.applicationConfig;
    }

    public void createDirectories(Path path, String errorMessage) {
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(errorMessage, path), e);
        }
    }

    protected void setOption(String key, Object attrName) {
        this.applicationConfig.setOption(key, String.valueOf(attrName));
    }

    protected <T> void setOptionArray(String key, T ... attrName) {
        StringBuilder value = new StringBuilder();
        for (T o : attrName) {
            value.append(",").append(o);
        }
        this.applicationConfig.setOption(key, value.length() == 0 ? "" : value.substring(1));
    }

    protected <T> void setOptionList(String key, List<T> attrName) {
        StringBuilder value = new StringBuilder();
        for (T o : attrName) {
            value.append(",").append(o);
        }
        this.applicationConfig.setOption(key, value.length() == 0 ? "" : value.substring(1));
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Os.name     = ").append(this.get().getOsName());
        builder.append("\n=== Os.arch     = ").append(this.get().getOsArch());
        builder.append("\n=== Os.username = ").append(this.get().getUsername());
        builder.append("\n=== Os.encoding  = ").append(this.get().getEncoding());
        for (ConfigOptionDef option : this.orderedByKey()) {
            String optionValue = this.get().getOption(option.getKey());
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), optionValue == null ? "Not defined" : optionValue));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<O> orderedByKey() {
        List<ConfigOptionDef> values = Arrays.asList(this.options());
        values.sort(Comparator.comparing(ConfigOptionDef::getKey));
        return Collections.unmodifiableList(values);
    }

    public File createDirectory(O option) {
        File dir = this.get().getOptionAsFile(option.getKey());
        this.createDirectory(dir);
        return dir;
    }

    public void createParentDirectory(O option) {
        File dir = this.get().getOptionAsFile(option.getKey()).getParentFile();
        this.createDirectory(dir);
    }

    public void unzipToDirectory(ConfigResource resource, O option, String message) throws IOException {
        File dir = this.get().getOptionAsFile(option.getKey());
        this.createDirectory(dir);
        if (log.isDebugEnabled()) {
            log.info(message);
        }
        try (InputStream inputStream = ConfigResource.openInternalStream(resource.getUrl());){
            Zips.uncompress((InputStream)inputStream, (File)dir);
        }
    }

    protected void createDirectory(File dir) {
        if (dir.exists()) {
            log.info(String.format("Directory %s exists.", dir));
        } else {
            log.info(String.format("Will create directory: %s", dir));
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not create directory: %s", dir));
            }
        }
    }
}

