/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.config;

import io.ultreia.java4all.config.ApplicationConfig;
import io.ultreia.java4all.config.ApplicationConfigSaveException;
import io.ultreia.java4all.config.ConfigResource;
import io.ultreia.java4all.config.spi.ConfigOptionDef;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigHelper {
    private static final Logger log = LogManager.getLogger(ConfigHelper.class);

    public static void save(ApplicationConfig applicationConfig, File file, Collection<String> doNotSave, ConfigResource resource, ConfigOptionDef[] options) {
        log.info(String.format("Save configuration to %s", file));
        Map<String, String> propertiesToSave = ConfigHelper.computePropertiesToSave(applicationConfig, doNotSave, options);
        List propertyNames = propertiesToSave.keySet().stream().sorted().collect(Collectors.toList());
        log.info(String.format("Property names to save: %s", propertyNames));
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            List<String> lines = resource.readLines();
            for (String line : lines) {
                if (line.startsWith("#")) {
                    for (String propertyName : propertyNames) {
                        if (!line.startsWith("#" + propertyName + "=")) continue;
                        line = String.format("%s=%s", propertyName, propertiesToSave.get(propertyName));
                    }
                }
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new ApplicationConfigSaveException(e);
        }
    }

    private static Map<String, String> computePropertiesToSave(ApplicationConfig applicationConfig, Collection<String> doNotSave, ConfigOptionDef[] options) {
        LinkedHashMap<String, String> propertiesToSave = new LinkedHashMap<String, String>();
        for (ConfigOptionDef option : options) {
            String optionDefaultValue;
            String optionValue;
            String optionKey;
            if (option.isTransient() || option.isFinal() || doNotSave.contains(optionKey = option.getKey()) || Objects.equals(optionValue = applicationConfig.getOption(optionKey), optionDefaultValue = option.getDefaultValue()) || Objects.equals(optionValue, applicationConfig.replaceRecursiveOptions(optionDefaultValue))) continue;
            propertiesToSave.put(optionKey, optionValue);
            log.debug("Option {} was modified (value: {})", (Object)optionKey, (Object)optionValue);
        }
        return propertiesToSave;
    }
}

