/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.config;

import io.ultreia.java4all.config.ApplicationConfig;
import java.io.File;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OptionList {
    protected ApplicationConfig config;
    protected String key;
    protected String value;

    public OptionList(ApplicationConfig config, String key, String value) {
        this.config = config;
        this.key = key;
        this.value = value;
    }

    protected <T> List<T> convertListOption(Class<T> type) {
        return (List)this.config.convertOption(type, this.key, this.value, true);
    }

    public <T> List<T> getOption(Class<T> type) {
        return this.convertListOption(type);
    }

    public List<String> getOption() {
        return this.convertListOption(String.class);
    }

    public List<File> getOptionAsFile() {
        List<File> tmp = this.convertListOption(File.class);
        ArrayList<File> result = new ArrayList<File>(tmp.size());
        for (File file : tmp) {
            result.add(file.getAbsoluteFile());
        }
        return result;
    }

    public List<URL> getOptionAsURL() {
        return this.convertListOption(URL.class);
    }

    public List<Class> getOptionAsClass() {
        return this.convertListOption(Class.class);
    }

    public List<Date> getOptionAsDate() {
        return this.convertListOption(Date.class);
    }

    public List<Time> getOptionAsTime() {
        return this.convertListOption(Time.class);
    }

    public List<Timestamp> getOptionAsTimestamp() {
        return this.convertListOption(Timestamp.class);
    }

    public List<Integer> getOptionAsInt() {
        return this.convertListOption(Integer.class);
    }

    public List<Double> getOptionAsDouble() {
        return this.convertListOption(Double.class);
    }

    public List<Boolean> getOptionAsBoolean() {
        return this.convertListOption(Boolean.class);
    }
}

