/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.config;

import io.ultreia.java4all.config.ApplicationConfig;
import io.ultreia.java4all.config.ApplicationConfigSaveException;
import io.ultreia.java4all.config.ConfigResource;
import io.ultreia.java4all.config.spi.ConfigOptionDef;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigHelper {
    private static final Logger log = LogManager.getLogger(ConfigHelper.class);

    public static void save(ApplicationConfig applicationConfig, File file, String[] doNotSave, ConfigResource resource, ConfigOptionDef[] options) {
        log.info(String.format("Save configuration to %s", file));
        Properties propertiesToSave = applicationConfig.getPropertiesToSave(false, doNotSave);
        List propertyNames = propertiesToSave.stringPropertyNames().stream().sorted().collect(Collectors.toList());
        for (ConfigOptionDef option : options) {
            String property;
            String optionKey = option.getKey();
            if (!propertyNames.contains(optionKey) || !Objects.equals(property = propertiesToSave.getProperty(optionKey), option.getDefaultValue())) continue;
            propertyNames.remove(optionKey);
        }
        log.info(String.format("Property names to save: %s", propertyNames));
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            List<String> lines = resource.readLines();
            for (String line : lines) {
                if (line.startsWith("#")) {
                    for (String propertyName : propertyNames) {
                        if (!line.startsWith("#" + propertyName + "=")) continue;
                        line = String.format("%s=%s", propertyName, propertiesToSave.getProperty(propertyName));
                    }
                }
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new ApplicationConfigSaveException(e);
        }
    }
}

