/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.config;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationConfigReflectionHelper {
    private static final Logger log = LogManager.getLogger(ApplicationConfigReflectionHelper.class);

    public static <E> E newInstance(Class<E> clazz, Collection<?> args, boolean nullIfMissing) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length != 1) {
            throw new IllegalArgumentException(String.format("Your class %s has more than one constructor", clazz));
        }
        LinkedList container = new LinkedList(args);
        Constructor<?> constructor = constructors[0];
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Object o;
            params[i] = o = ApplicationConfigReflectionHelper.choiceArgument(paramTypes[i], container, nullIfMissing);
        }
        try {
            return (E)constructor.newInstance(params);
        }
        catch (Exception eee) {
            throw new IllegalArgumentException(String.format("Class %s can't be instantiated with %s", clazz, Arrays.toString(params)), eee);
        }
    }

    public static Object choiceArgument(Class<?> clazz, List args, boolean nullIfMissing) {
        Object result = null;
        boolean addResult = false;
        for (Object o : args) {
            if (o == null) continue;
            if (o instanceof Class && clazz.isAssignableFrom((Class)o)) {
                result = ApplicationConfigReflectionHelper.newInstance((Class)o, args, nullIfMissing);
                addResult = true;
                break;
            }
            if (!clazz.isInstance(o)) continue;
            result = o;
            break;
        }
        if (addResult) {
            args.add(0, result);
        }
        if (result == null && !nullIfMissing) {
            throw new IllegalArgumentException(String.format("Can't find assignable argument for %s in %s", clazz, args));
        }
        return result;
    }

    public static List<Method> getMethod(Class<?> clazz, String methodName, boolean ignoreCase) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : methods = clazz.getMethods()) {
            if ((!ignoreCase || !methodName.equalsIgnoreCase(m.getName())) && !methodName.equals(m.getName())) continue;
            result.add(m);
        }
        return result;
    }

    public static List<Method> getMethod(String name, boolean ignoreCase) {
        Class<?> clazz;
        int sep = name.lastIndexOf("#");
        if (sep == -1) {
            throw new IllegalArgumentException(String.format("Can't find method in %s", name));
        }
        String className = name.substring(0, sep);
        String methodName = name.substring(sep + 1);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException eee) {
            throw new IllegalArgumentException(String.format("Can't find class %s", className));
        }
        return ApplicationConfigReflectionHelper.getMethod(clazz, methodName, ignoreCase);
    }

    public static Object call(Object o, Method m, String ... params) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        Class<?>[] types = m.getParameterTypes();
        if (!m.isVarArgs() && params.length != types.length) {
            throw new IllegalArgumentException(String.format("Bad number params we have %1$s parameters and waiting %2$s.", params.length, types.length));
        }
        int last = types.length;
        if (m.isVarArgs()) {
            --last;
        }
        Object[] parameters = new Object[types.length];
        for (int i = 0; i < last; ++i) {
            Object t;
            String v = params[i];
            Class<?> clazz = types[i];
            parameters[i] = t = ApplicationConfigReflectionHelper.convert(v, clazz);
        }
        if (m.isVarArgs()) {
            Class<?> clazz = types[last];
            clazz = clazz.getComponentType();
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (int i = last; i < params.length; ++i) {
                String v = params[i];
                Object t = ApplicationConfigReflectionHelper.convert(v, clazz);
                tmp.add(t);
            }
            parameters[last] = tmp.toArray((Object[])Array.newInstance(clazz, tmp.size()));
        }
        log.debug(String.format("Invoke %s with %s", m, Arrays.toString(parameters)));
        return m.invoke(o, parameters);
    }

    public static Object convert(String v, Class<?> clazz) {
        Object t = ConvertUtils.convert((String)v, clazz);
        if (t != null && !String.class.getName().equals(clazz.getName()) && String.class.getName().equals(t.getClass().getName())) {
            throw new IllegalArgumentException(String.format("Can convert argument to correct type. %s can't be converted from String to %s conversion is done to %s", v, clazz.getName(), t.getClass().getName()));
        }
        return t;
    }
}

