/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.config;

import io.ultreia.java4all.config.ApplicationConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigResource {
    private static final Logger log = LogManager.getLogger(ConfigResource.class);
    private final String location;
    private URL url;

    public static InputStream openInternalStream(URL resource) {
        try {
            return Objects.requireNonNull(resource.openStream(), String.format("Could not find internal resource %s", resource));
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not treat internal resource %s", resource), e);
        }
    }

    public static void loadFile(URL url, Path target, Supplier<ApplicationConfig> configSupplier) {
        if (Files.notExists(target, new LinkOption[0])) {
            LinkedList<String> content = new LinkedList<String>();
            ApplicationConfig applicationConfig = configSupplier.get();
            try {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        content.add(applicationConfig.replaceRecursiveOptions(line));
                    }
                }
                Files.write(target, content, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not copy resource %s to %s", url, target), e);
            }
        }
    }

    public static Properties load(File file) throws IOException {
        URL url = file.toURI().toURL();
        return ConfigResource.load(url);
    }

    public static Properties load(URL url) throws IOException {
        Properties result;
        try (InputStream in = ConfigResource.openInternalStream(url);){
            result = new Properties();
            result.load(in);
        }
        return result;
    }

    public ConfigResource(String location) {
        this.location = location;
    }

    public Properties load() throws IOException {
        return ConfigResource.load(this.getUrl());
    }

    public URL getResource(String location) {
        URL resource = this.getClass().getResource(location);
        Objects.requireNonNull(resource, String.format("Could not find internal resource %s", location));
        try (InputStream in = ConfigResource.openInternalStream(resource);){
            log.debug("opening: " + in);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not treat internal resource %s", resource), e);
        }
        return resource;
    }

    public boolean copyResource(Path sharedFile, File file) {
        if (Files.exists(sharedFile, new LinkOption[0])) {
            try {
                Files.createSymbolicLink(file.toPath(), sharedFile, new FileAttribute[0]);
                return false;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not make symbolic link from %s to %s", sharedFile, file), e);
            }
        }
        this.copyResource(file);
        return true;
    }

    public void copyResource(File file) {
        try (InputStream in = ConfigResource.openInternalStream(this.getUrl());){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not copy resource %s to %s", this, file), e);
        }
    }

    public URL getUrl() {
        if (this.url == null) {
            this.url = this.getResource(this.location);
        }
        return this.url;
    }

    public boolean exists(File directory) {
        File file = this.getFile(directory);
        return file.exists();
    }

    public File getFile(File directory) {
        return new File(directory, this.location.substring(1));
    }
}

