/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.config;

import io.ultreia.java4all.config.ConfigActionDef;
import io.ultreia.java4all.config.ConfigOptionDef;
import io.ultreia.java4all.config.io.spi.ActionModel;
import io.ultreia.java4all.config.io.spi.ConfigModel;
import io.ultreia.java4all.config.io.spi.OptionModel;
import java.util.LinkedList;
import java.util.Locale;

public interface ApplicationConfigProvider {
    public String getName();

    public String getDescription(Locale var1);

    public ConfigOptionDef[] getOptions();

    public ConfigActionDef[] getActions();

    default public ConfigModel toModel(Locale locale) {
        ConfigModel configModel = new ConfigModel();
        configModel.setName(this.getName());
        configModel.setDescription(this.getDescription(locale));
        LinkedList<OptionModel> optionModels = new LinkedList<OptionModel>();
        for (ConfigOptionDef configOptionDef : this.getOptions()) {
            optionModels.add(ConfigOptionDef.of(configOptionDef));
        }
        configModel.setOptions(optionModels);
        LinkedList<ActionModel> actionModels = new LinkedList<ActionModel>();
        for (ConfigActionDef configActionDef : this.getActions()) {
            actionModels.add(ConfigActionDef.of(configActionDef));
        }
        configModel.setActions(actionModels);
        return configModel;
    }
}

