/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.config;

import io.ultreia.java4all.config.ApplicationConfigScope;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;

public class ApplicationConfigInit {
    protected String configFilename;
    protected Properties defaults;
    protected final Set<ApplicationConfigScope> scopes;
    protected String readFormat = "properties";

    public static ApplicationConfigInit defaultInit() {
        return ApplicationConfigInit.forAllScopes();
    }

    public static ApplicationConfigInit forAllScopes() {
        return new ApplicationConfigInit(ApplicationConfigScope.values());
    }

    public static ApplicationConfigInit forAllScopesWithout(ApplicationConfigScope ... excludedScopes) {
        LinkedList<ApplicationConfigScope> allScopes = new LinkedList<ApplicationConfigScope>(Arrays.asList(ApplicationConfigScope.values()));
        for (ApplicationConfigScope scope : excludedScopes) {
            allScopes.remove((Object)scope);
        }
        return new ApplicationConfigInit(allScopes.toArray(new ApplicationConfigScope[0]));
    }

    public static ApplicationConfigInit forScopes(ApplicationConfigScope ... scopes) {
        return new ApplicationConfigInit(scopes);
    }

    protected ApplicationConfigInit(ApplicationConfigScope ... scopes) {
        this.scopes = Collections.unmodifiableSet(EnumSet.copyOf(Arrays.asList(scopes)));
    }

    public ApplicationConfigInit setConfigFileName(String configFilename) {
        this.configFilename = configFilename;
        return this;
    }

    public ApplicationConfigInit setDefaults(Properties defaults) {
        this.defaults = defaults;
        return this;
    }

    public String getConfigFilename() {
        return this.configFilename;
    }

    public Properties getDefaults() {
        return this.defaults;
    }

    public Set<ApplicationConfigScope> getScopes() {
        return this.scopes;
    }

    public String getReadFormat() {
        return this.readFormat;
    }

    public ApplicationConfigInit useIniFormat() {
        this.readFormat = "ini";
        return this;
    }

    public ApplicationConfigInit useTomlFormat() {
        this.readFormat = "toml";
        return this;
    }

    public ApplicationConfigInit useYamlFormat() {
        this.readFormat = "yaml";
        return this;
    }
}

