/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.application.template;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import io.ultreia.java4all.application.template.TemplateGeneratorConfig;
import io.ultreia.java4all.application.template.TemplateGeneratorException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemplateGenerator {
    private static final Logger log = LogManager.getLogger(TemplateGenerator.class);
    private final TemplateGeneratorConfig templateGeneratorConfig;
    private final Configuration freemarkerConfiguration;

    public TemplateGenerator(TemplateGeneratorConfig templateGeneratorConfig) {
        this.templateGeneratorConfig = templateGeneratorConfig;
        this.freemarkerConfiguration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.freemarkerConfiguration.setEncoding(Locale.getDefault(), "UTF-8");
        try {
            FileTemplateLoader templateLoader = new FileTemplateLoader(templateGeneratorConfig.getTemplatesDirectory());
            this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
        }
        catch (IOException e) {
            throw new TemplateGeneratorException("Can't init template loader at ", e);
        }
    }

    protected String generate(String templateName, Object model) {
        Locale locale = this.templateGeneratorConfig.getLocale();
        log.info(String.format("Will generate template: %s, locale: %s, model: %s", templateName, locale, model));
        try {
            Template mapTemplate = this.freemarkerConfiguration.getTemplate(templateName, locale);
            StringWriter out = new StringWriter();
            mapTemplate.process(model, (Writer)out);
            ((Writer)out).flush();
            return ((Object)out).toString();
        }
        catch (Exception ex) {
            throw new TemplateGeneratorException(String.format("Could not generate from template %s and model %s.", templateName, model), ex);
        }
    }

    protected TemplateGeneratorConfig getTemplateGeneratorConfig() {
        return this.templateGeneratorConfig;
    }
}

