/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.application.template.spi;

import io.ultreia.java4all.application.template.TemplateSupport;
import io.ultreia.java4all.application.template.spi.GenerateTemplate;
import io.ultreia.java4all.util.ImportManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Generated;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;

@SupportedAnnotationTypes(value={"io.ultreia.java4all.application.template.spi.GenerateTemplate"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"debug", "quiet"})
public class GenerateTemplateProcessor
extends AbstractProcessor {
    private static final String TEMPLATE_JAVA_FILE = "package %1$s;\n\n%2$s\n@Generated(value = \"%3$s\", date = \"%4$s\")\npublic class %5$sTemplate extends TemplateSupport<%5$s> {\n    private static %5$sTemplate INSTANCE = new %5$sTemplate();\n \n%6$s\n}\n";
    private static final String METHOD_TEMPLATE = "    public static String generate%1$s(%2$s model) {\n        return INSTANCE.generate(\"%3$s\", model);\n    }\n";
    private Set<String> done = new TreeSet<String>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                String generatedClassName;
                String packageName;
                TypeElement classElement = (TypeElement)element;
                String fullyQualifiedName = classElement.getQualifiedName().toString();
                String fullClassName = fullyQualifiedName.substring((packageName = this.processingEnv.getElementUtils().getPackageOf(classElement).toString()).length() + 1);
                String className = fullClassName;
                int i = className.indexOf(".");
                if (i > -1) {
                    className = className.substring(i + 1);
                }
                if (!this.done.add(generatedClassName = packageName + "." + className + "Template")) {
                    this.logWarning(String.format("Skip already processed class: %s", generatedClassName));
                    continue;
                }
                this.logDebug(String.format("Detect application template: %s", classElement));
                GenerateTemplate realAnnotation = classElement.getAnnotation(GenerateTemplate.class);
                try {
                    this.generateFile(realAnnotation, packageName, generatedClassName, fullClassName, className);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Can't generate template file for: %s", classElement), e);
                }
            }
        }
        return true;
    }

    private void generateFile(GenerateTemplate realAnnotation, String packageName, String generatedClassName, String fullClassName, String className) throws IOException {
        ImportManager importManager = new ImportManager(packageName);
        importManager.addImport(Generated.class);
        importManager.addImport(TemplateSupport.class);
        if (!className.equals(fullClassName)) {
            importManager.addImport(packageName + "." + fullClassName);
        }
        String imports = importManager.getImportsSection("\n");
        StringBuilder methodsBuilder = new StringBuilder();
        String[] templates = realAnnotation.template();
        if (templates.length == 1) {
            methodsBuilder.append(String.format(METHOD_TEMPLATE, "", className, templates[0]));
        } else {
            for (String template : templates) {
                String name = StringUtils.capitalize((String)StringUtils.removeEnd((String)template, (String)".ftl"));
                methodsBuilder.append(String.format(METHOD_TEMPLATE, name, className, template));
            }
        }
        String content = String.format(TEMPLATE_JAVA_FILE, packageName, imports, this.getClass().getName(), new Date(), className, methodsBuilder.toString());
        this.generate(generatedClassName, content);
    }

    private void generate(String generatedClassName, String content) throws IOException {
        this.logInfo(String.format("Generate application template: %s", generatedClassName));
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(generatedClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            out.print(content);
        }
    }

    private void logDebug(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void logWarning(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
    }

    private void logInfo(String msg) {
        if (!this.processingEnv.getOptions().containsKey("quiet")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }
}

