/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.application.context;

import io.ultreia.java4all.util.SingletonSupplier;
import java.io.Closeable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationComponentValueSupplier<O>
extends SingletonSupplier<O>
implements Closeable {
    private static final Logger log = LogManager.getLogger(ApplicationComponentValueSupplier.class);
    private final Class<O> componentType;
    private final List<Class<?>> dependencies;
    private final List<Class<?>> hints;

    public static <O> Builder<O> on(Class<O> componentType) {
        return new Builder<O>(componentType);
    }

    public ApplicationComponentValueSupplier(Class<O> componentType, List<Class<?>> dependencies, List<Class<?>> hints, boolean requireNotNull, Supplier<O> supplier) {
        super(supplier, requireNotNull);
        this.componentType = Objects.requireNonNull(componentType);
        this.dependencies = Collections.unmodifiableList(Objects.requireNonNull(dependencies));
        this.hints = Collections.unmodifiableList(Objects.requireNonNull(hints));
    }

    public List<Class<?>> dependencies() {
        return this.dependencies;
    }

    public List<Class<?>> hints() {
        return this.hints;
    }

    public O get() {
        if (!this.withValue()) {
            log.info(String.format("Create component value from supplier: %s - %s", this.componentType.getName(), this));
        }
        return (O)super.get();
    }

    public Optional<O> clear() {
        if (this.withValue()) {
            log.info(String.format("Clear component value: %s", this.componentType.getName()));
        }
        return super.clear();
    }

    @Override
    public void close() {
        this.clear();
    }

    public Class<O> componentType() {
        return this.componentType;
    }

    public static class Builder<O> {
        private final Class<O> componentType;
        private final List<Class<?>> dependencies;
        private final List<Class<?>> hints;
        private boolean requireNotNull;
        private Supplier<O> supplier;

        public Builder(Class<O> componentType) {
            this.componentType = Objects.requireNonNull(componentType);
            this.dependencies = new LinkedList();
            this.hints = new LinkedList();
        }

        public Builder<O> requireNotNull() {
            this.requireNotNull = true;
            return this;
        }

        public Builder<O> setSupplier(Supplier<O> supplier) {
            this.supplier = Objects.requireNonNull(supplier);
            return this;
        }

        public Builder<O> setDependencies(Class<?> ... dependencies) {
            Collections.addAll(this.dependencies, dependencies);
            return this;
        }

        public Builder<O> setHints(Class<?> ... hints) {
            Collections.addAll(this.hints, hints);
            return this;
        }

        public ApplicationComponentValueSupplier<O> build() {
            return new ApplicationComponentValueSupplier<O>(this.componentType, this.dependencies, this.hints, this.requireNotNull, this.supplier);
        }
    }
}

