/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.application.context;

import io.ultreia.java4all.application.context.ApplicationComponentValueSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationComponent<O>
implements Supplier<O>,
Closeable {
    private static final Logger log = LogManager.getLogger(ApplicationComponent.class);
    private final String name;
    private final ApplicationComponentValueSupplier<O> supplier;

    protected ApplicationComponent(String name, ApplicationComponentValueSupplier<O> supplier) {
        this.name = Objects.requireNonNull(name);
        this.supplier = Objects.requireNonNull(supplier);
    }

    @Override
    public O get() {
        return this.supplier.get();
    }

    public String getName() {
        return this.name;
    }

    public Class<O> getComponentType() {
        return this.supplier.componentType();
    }

    public void setValue(O value) {
        this.supplier.setSupplier(() -> value);
    }

    @Override
    public void close() throws IOException {
        log.info("Closing component: " + this);
        if (this.supplier.withValue()) {
            if (Closeable.class.isAssignableFrom(this.getComponentType())) {
                ((Closeable)this.supplier.get()).close();
            }
            this.supplier.clear();
        }
    }

    public boolean withDependencies() {
        return !this.getDependencies().isEmpty();
    }

    public List<Class<?>> getDependencies() {
        return this.supplier.dependencies();
    }

    public List<Class<?>> getHints() {
        return this.supplier.hints();
    }

    public String toString() {
        return String.format("%s \u2192 %s", this.name, this.getComponentType().getName());
    }
}

