/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.application.context.spi;

import com.google.auto.service.AutoService;
import io.ultreia.java4all.application.context.ApplicationComponent;
import io.ultreia.java4all.application.context.ApplicationComponentSupplier;
import io.ultreia.java4all.application.context.ApplicationComponentValueSupplier;
import io.ultreia.java4all.application.context.ApplicationContext;
import io.ultreia.java4all.application.context.spi.ApplicationComponentInstantiateStrategy;
import io.ultreia.java4all.application.context.spi.GenerateApplicationComponent;
import io.ultreia.java4all.util.ImportManager;
import io.ultreia.java4all.util.SingletonSupplier;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Generated;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.ultreia.java4all.application.context.spi.GenerateApplicationComponent"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_10)
@SupportedOptions(value={"debug", "quiet"})
public class GenerateApplicationComponentProcessor
extends AbstractProcessor {
    private static final String COMPONENT_JAVA_FILE = "package %1$s;\n\n%2$s\n@AutoService(value = ApplicationComponent.class)\n@Generated(value = \"%3$s\", date = \"%4$s\")\npublic class %5$sApplicationComponent extends ApplicationComponent<%5$s> {\n\n    public static ApplicationComponentSupplier<%5$s, %5$sApplicationComponent> INSTANCE = ApplicationContext.componentSupplier(%5$s.class, %5$sApplicationComponent.class);\n\n    public static %5$sApplicationComponent component() {\n        return INSTANCE.get();\n    }\n    public static %5$s value() {\n        return component().get();\n    }\n\n    public %5$sApplicationComponent() {\n        %7$s\n    }\n}\n";
    private static final String INTERFACE_JAVA_FILE = "package %1$s;\n\n%2$s\n@Generated(value = \"%3$s\", date = \"%4$s\")\npublic interface With%5$s {\n\n    default %5$s get%5$s() {\n        return %5$sApplicationComponent.value();\n    }\n}\n";
    private Set<String> done = new TreeSet<String>();
    private Elements elementUtils;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.elementUtils = this.processingEnv.getElementUtils();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                String generatedClassName;
                String packageName;
                TypeElement classElement = (TypeElement)element;
                String fullyQualifiedName = classElement.getQualifiedName().toString();
                String fullClassName = fullyQualifiedName.substring((packageName = this.processingEnv.getElementUtils().getPackageOf(classElement).toString()).length() + 1);
                String className = fullClassName;
                int i = className.indexOf(".");
                if (i > -1) {
                    className = className.substring(i + 1);
                }
                if (!this.done.add(generatedClassName = packageName + "." + className + "ApplicationComponent")) {
                    this.logWarning(String.format("Skip already processed class: %s", generatedClassName));
                    continue;
                }
                this.logDebug(String.format("Detect application component: %s", classElement));
                Map<String, AnnotationValue> elementValues = this.getAnnotation(classElement);
                try {
                    this.generateDefinitionFile(packageName, generatedClassName, fullClassName, className, elementValues);
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't generate JavaBean definition file for: " + classElement, e);
                }
                if (!Boolean.parseBoolean(elementValues.get("generateInterface").toString())) continue;
                try {
                    String generatedInterfaceSimpleName = "With" + className;
                    String generatedInterfaceName = packageName + "." + generatedInterfaceSimpleName;
                    this.generateInterfaceFile(packageName, generatedInterfaceName, className);
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't generate JavaBean definition file for: " + classElement, e);
                }
            }
        }
        return true;
    }

    private void generateInterfaceFile(String packageName, String generatedClassName, String className) throws IOException {
        ImportManager importManager = new ImportManager(packageName);
        importManager.addImport(Generated.class);
        importManager.addImport(ApplicationContext.class);
        importManager.addImport(ApplicationComponent.class);
        importManager.addImport(SingletonSupplier.class);
        String imports = importManager.getImportsSection("\n");
        String content = String.format(INTERFACE_JAVA_FILE, packageName, imports, this.getClass().getName(), new Date(), className);
        this.generate(generatedClassName, content);
    }

    private void generateDefinitionFile(String packageName, String generatedClassName, String fullClassName, String className, Map<String, AnnotationValue> elementValues) throws IOException {
        String constructor;
        ImportManager importManager = new ImportManager(packageName);
        importManager.addImport(Generated.class);
        importManager.addImport(AutoService.class);
        importManager.addImport(ApplicationContext.class);
        importManager.addImport(ApplicationComponent.class);
        importManager.addImport(ApplicationComponentSupplier.class);
        if (!className.equals(fullClassName)) {
            importManager.addImport(packageName + "." + fullClassName);
        }
        StringBuilder dependenciesBuilder = new StringBuilder("new Class[]{");
        StringBuilder hintsBuilder = new StringBuilder("new Class[]{");
        int index = 0;
        List hints = (List)elementValues.get("hints").getValue();
        for (Object hint : hints) {
            TypeElement typeMirror = this.elementUtils.getTypeElement(hint.toString().substring(0, hint.toString().length() - 6));
            importManager.addImport(typeMirror.getQualifiedName().toString());
            if (index++ > 0) {
                hintsBuilder.append(", ");
            }
            hintsBuilder.append(typeMirror.getSimpleName()).append(".class");
        }
        hintsBuilder.append("}");
        try {
            List dependencies = (List)elementValues.get("dependencies").getValue();
            if (dependencies.size() > 0) {
                index = 0;
                for (Object dependency : dependencies) {
                    TypeElement typeMirror = this.elementUtils.getTypeElement(dependency.toString().substring(0, dependency.toString().length() - 6));
                    importManager.addImport(typeMirror.getQualifiedName().toString());
                    if (index++ > 0) {
                        dependenciesBuilder.append(", ");
                    }
                    dependenciesBuilder.append(typeMirror.getSimpleName()).append(".class");
                }
            }
        }
        catch (Exception dependencies) {
            // empty catch block
        }
        dependenciesBuilder.append("}");
        String dependenciesStr = dependenciesBuilder.toString();
        boolean requireNotNull = Boolean.parseBoolean(elementValues.get("requireNotNull").toString());
        String name = elementValues.get("name").toString();
        ApplicationComponentInstantiateStrategy instantiateStrategy = ApplicationComponentInstantiateStrategy.valueOf(elementValues.get("instantiateStrategy").getValue().toString());
        importManager.addImport(ApplicationComponentInstantiateStrategy.class);
        switch (instantiateStrategy) {
            case CONSTRUCTOR: 
            case SERVICE_LOADER: {
                constructor = String.format("super(%1$s, %2$s.class,%3$b, ApplicationComponentInstantiateStrategy.%4$s,%5$s,%6$s);", name, className, requireNotNull, instantiateStrategy.name(), hintsBuilder.toString(), dependenciesStr);
                break;
            }
            case SUPPLIER: {
                Object instantiateSupplier = elementValues.get("instantiateSupplier").getValue();
                TypeElement typeMirror = this.elementUtils.getTypeElement(instantiateSupplier.toString());
                importManager.addImport(typeMirror.getQualifiedName().toString());
                importManager.addImport(ApplicationComponentValueSupplier.class);
                constructor = String.format("super(%1$s, %2$s,%3$b, ApplicationComponentInstantiateStrategy.%4$s,%5$s,%6$s, new ApplicationComponentValueSupplier<>(%2$s, %3$b, new %7$s()));", name, className + ".class", requireNotNull, instantiateStrategy.name(), hintsBuilder.toString(), dependenciesStr, typeMirror.getSimpleName());
                break;
            }
            default: {
                throw new IllegalStateException("Can't use it now!!!");
            }
        }
        String imports = importManager.getImportsSection("\n");
        String content = String.format(COMPONENT_JAVA_FILE, packageName, imports, this.getClass().getName(), new Date(), className, name, constructor);
        this.generate(generatedClassName, content);
    }

    private void generate(String generatedClassName, String content) throws IOException {
        this.logInfo("Generate application component: " + generatedClassName);
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(generatedClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            out.print(content);
        }
    }

    private void logDebug(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void logWarning(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
    }

    private void logInfo(String msg) {
        if (!this.processingEnv.getOptions().containsKey("quiet")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private Map<String, AnnotationValue> getAnnotation(TypeElement classElement) {
        List<? extends AnnotationMirror> annos = this.elementUtils.getAllAnnotationMirrors(classElement);
        TypeMirror typeMirror = this.elementUtils.getTypeElement(GenerateApplicationComponent.class.getName()).asType();
        AnnotationMirror annotationMirror = annos.stream().filter(a -> a.getAnnotationType().equals(typeMirror)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Can't find annotation %s on class %s", GenerateApplicationComponent.class.getName(), classElement.getQualifiedName())));
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValuesWithDefaults = this.elementUtils.getElementValuesWithDefaults(annotationMirror);
        TreeMap<String, AnnotationValue> result = new TreeMap<String, AnnotationValue>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValuesWithDefaults.entrySet()) {
            AnnotationValue value = entry.getValue();
            result.put(entry.getKey().getSimpleName().toString(), value);
        }
        return result;
    }
}

