/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.application.context;

import io.ultreia.java4all.application.context.ApplicationComponent;
import io.ultreia.java4all.application.context.ApplicationContext;
import io.ultreia.java4all.application.context.spi.ApplicationComponentInstantiateStrategy;
import io.ultreia.java4all.util.ServiceLoaders;
import io.ultreia.java4all.util.SingletonSupplier;
import java.io.Closeable;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationComponentValueSupplier<O>
extends SingletonSupplier<O>
implements Closeable {
    private static final Logger log = LogManager.getLogger(ApplicationComponentValueSupplier.class);
    private final Class<O> componentType;

    static <O> ApplicationComponentValueSupplier<O> create(final Class<O> componentType, boolean requireNotNull, ApplicationComponentInstantiateStrategy instantiateStrategy, Class<?> ... dependencies) {
        switch (instantiateStrategy) {
            case CONSTRUCTOR: {
                return new ApplicationComponentValueSupplier<O>(componentType, requireNotNull, ApplicationComponentValueSupplier.createFromConstructor(componentType, dependencies));
            }
            case SERVICE_LOADER: {
                return new ApplicationComponentValueSupplier<O>(componentType, requireNotNull, ApplicationComponentValueSupplier.createFromServiceLoader(componentType)){

                    @Override
                    public Optional<O> clear() {
                        log.info(String.format("Reload ServiceLoader for: %s", componentType.getName()));
                        ServiceLoaders.reload((Class)componentType);
                        return super.clear();
                    }
                };
            }
        }
        return null;
    }

    private static <O> Supplier<O> createFromConstructor(Class<O> componentType, Class<?> ... dependencies) {
        int dependenciesLength = dependencies.length;
        if (dependenciesLength == 0) {
            return () -> {
                log.info(String.format("Create component value from default constructor: %s", componentType.getName()));
                try {
                    return componentType.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't instantiate component: " + componentType.getName(), e);
                }
            };
        }
        return () -> {
            Object[] parameters = new Object[dependenciesLength];
            ApplicationContext applicationContext = ApplicationContext.get();
            log.info(String.format("Create component value from constructor: %s with %d dependencies", componentType.getName(), dependenciesLength));
            for (int i = 0; i < dependenciesLength; ++i) {
                Class dependency = dependencies[i];
                log.info(String.format(">> Get dependency %3d/%3d - %s", i, dependenciesLength, dependency.getName()));
                ApplicationComponent component = applicationContext.getComponent(dependency);
                log.info(String.format("<< Get dependency %3d/%3d - %s : %s", i, dependenciesLength, dependency.getName(), component));
                parameters[i] = component.get();
            }
            try {
                return componentType.getDeclaredConstructor(dependencies).newInstance(parameters);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't get component: " + componentType.getName(), e);
            }
        };
    }

    private static <O> Supplier<O> createFromServiceLoader(Class<O> componentType) {
        return () -> {
            try {
                log.info(String.format("Create component value from service loader: %s", componentType.getName()));
                return ServiceLoaders.loadUniqueService((Class)componentType);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't get component: " + componentType.getName(), e);
            }
        };
    }

    public ApplicationComponentValueSupplier(Class<O> componentType, boolean requireNotNull, Supplier<O> supplier) {
        super(supplier, requireNotNull);
        this.componentType = componentType;
    }

    public O get() {
        if (!this.withValue()) {
            log.info(String.format("Create component value from supplier: %s - %s", this.componentType.getName(), this));
        }
        return (O)super.get();
    }

    public Optional<O> clear() {
        if (this.withValue()) {
            log.info(String.format("Clear component value: %s", this.componentType.getName()));
        }
        return super.clear();
    }

    @Override
    public void close() {
        this.clear();
    }
}

