/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.application.context;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import io.ultreia.java4all.application.context.ApplicationComponent;
import io.ultreia.java4all.application.context.ApplicationComponentSupplier;
import io.ultreia.java4all.util.ServiceLoaders;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationContext
implements Closeable {
    private static final Logger log = LogManager.getLogger(ApplicationContext.class);
    private static ApplicationContext INSTANCE;
    private static final List<ApplicationComponentSupplier<?, ? extends ApplicationComponent<?>>> COMPONENT_SUPPLIERS;
    private final List<ApplicationComponent<?>> components;
    private final Map<Class<?>, ApplicationComponent<?>> componentsCache;
    private final List<MutableInt> componentsRoundInReverseOrder;
    private final ListMultimap<MutableInt, ApplicationComponent<?>> componentsByRound;
    private final Object lock;
    protected boolean closed;

    public static boolean isInit() {
        return INSTANCE != null;
    }

    public static ApplicationContext get() {
        return Objects.requireNonNull(INSTANCE, "No client application context found.");
    }

    public static <O, C extends ApplicationComponent<O>> ApplicationComponentSupplier<O, C> componentSupplier(Class<O> componentValueType, Class<C> componentType) {
        ApplicationComponentSupplier<O, C> result = new ApplicationComponentSupplier<O, C>(componentValueType, componentType);
        COMPONENT_SUPPLIERS.add(result);
        return result;
    }

    public ApplicationContext() {
        INSTANCE = this;
        log.info(">>");
        log.info(">> Init application context.");
        log.info(">>");
        this.lock = new Object();
        this.components = new LinkedList();
        this.componentsCache = new LinkedHashMap();
        LinkedHashMap componentMap = new LinkedHashMap();
        for (ApplicationComponent component : ServiceLoaders.reload(ApplicationComponent.class)) {
            componentMap.put(component.getComponentType(), component);
        }
        this.registerComponents(componentMap);
        this.componentsByRound = this.computeComponentsReverseOrder();
        LinkedList componentsRoundInReverseOrder = new LinkedList(this.componentsByRound.keySet());
        Collections.reverse(componentsRoundInReverseOrder);
        this.componentsRoundInReverseOrder = Collections.unmodifiableList(componentsRoundInReverseOrder);
        int index = 0;
        int round = 0;
        int componentsCount = this.components.size();
        for (Map.Entry entry : this.componentsByRound.asMap().entrySet()) {
            int roundIndex = 0;
            int roundCount = ((Collection)entry.getValue()).size();
            for (ApplicationComponent component : (Collection)entry.getValue()) {
                log.info(String.format("Component (round %3d - %3d/%3d) - %3d/%3d: %s", round, ++roundIndex, roundCount, ++index, componentsCount, component));
            }
            ++round;
        }
        log.info("<<");
        log.info("<< Init application context.");
        log.info("<<");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    @Override
    public void close() {
        int count;
        int index;
        log.info(">>");
        log.info(">> Closing application context.");
        log.info(">>");
        this.closed = true;
        LinkedList<ApplicationComponent> componentsToUnregister = new LinkedList<ApplicationComponent>();
        if (this.componentsByRound != null) {
            index = 0;
            count = this.components.size();
            for (MutableInt mutableInt : this.componentsRoundInReverseOrder) {
                for (ApplicationComponent component : this.componentsByRound.get((Object)mutableInt)) {
                    try {
                        log.info(String.format("Closing component: (%3d/%3d) %s", ++index, count, component));
                        component.close();
                        componentsToUnregister.add(component);
                    }
                    catch (IOException e) {
                        log.error("Can't close component: " + component, (Throwable)e);
                    }
                }
            }
            index = 0;
            for (ApplicationComponent applicationComponent : componentsToUnregister) {
                log.info(String.format("Unregister component: (%3d/%3d) %s", ++index, count, applicationComponent.getName()));
                this.unregisterComponent(applicationComponent);
            }
        }
        index = 0;
        count = COMPONENT_SUPPLIERS.size();
        for (ApplicationComponentSupplier<?, ? extends ApplicationComponent<?>> applicationComponentSupplier : COMPONENT_SUPPLIERS) {
            log.info(String.format("Remove component supplier: (%3d/%3d) %s", new Object[]{++index, count, applicationComponentSupplier}));
            applicationComponentSupplier.clear();
        }
        INSTANCE = null;
        log.info("<<");
        log.info("<< Closing application context.");
        log.info("<<");
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
        super.finalize();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <O, C extends ApplicationComponent<O>> C getComponentTyped(Class<O> componentValueType, Class<C> componentType) {
        return (C)((ApplicationComponent)componentType.cast(this.getComponent(componentValueType)));
    }

    public <O> ApplicationComponent<O> getComponent(Class<O> componentType) {
        ApplicationComponent<O> result = this.getComponentFromCache(Objects.requireNonNull(componentType));
        if (result == null && (result = this.getComponentFromComponents(componentType)) != null) {
            this.componentsCache.put(componentType, result);
        }
        return Objects.requireNonNull(result, "Can't find component of type: " + componentType.getName());
    }

    public <O> O getComponentValue(Class<O> componentType) {
        ApplicationComponent<O> result = this.getComponent(Objects.requireNonNull(componentType));
        return Objects.requireNonNull(result, "Can't find component of type: " + componentType.getName()).get();
    }

    protected void registerComponents(Map<Class<?>, ApplicationComponent<?>> componentMap) {
        for (Map.Entry<Class<?>, ApplicationComponent<?>> entry : componentMap.entrySet()) {
            ApplicationComponent<?> component = entry.getValue();
            log.debug(String.format("Register component (%3d): %s", this.components.size(), component));
            this.registerComponent(component);
        }
    }

    protected <O> void registerComponent(ApplicationComponent<O> component) {
        Class<O> componentType = Objects.requireNonNull(component).getComponentType();
        ApplicationComponent<O> existingComponent = this.getComponentFromComponents(componentType);
        if (existingComponent != null) {
            throw new IllegalArgumentException(String.format("There is already a such component for type: %s", componentType.getName()));
        }
        int index = this.components.size();
        log.info(String.format("Register component (%3d): %s", index, component));
        this.components.add(component);
        this.componentsCache.put(componentType, component);
        for (Class<?> extraBinding : component.getHints()) {
            if (this.componentsCache.containsKey(extraBinding)) {
                throw new IllegalArgumentException(String.format("There is already a such component %s with hint: %s", this.componentsCache.get(extraBinding), extraBinding.getName()));
            }
            log.info(String.format("Register component (%3d): %s {hint \u2192 '%s'}", index, component, extraBinding.getName()));
            this.componentsCache.put(extraBinding, component);
        }
    }

    private <O> void unregisterComponent(ApplicationComponent<O> component) {
        log.debug(String.format("Unregister component: %s", component));
        this.components.remove(component);
        this.componentsCache.entrySet().removeIf(entry -> component.equals(entry.getValue()));
    }

    private <O> ApplicationComponent<O> getComponentFromCache(Class<O> componentType) {
        return this.componentsCache.get(Objects.requireNonNull(componentType));
    }

    private <O> ApplicationComponent<O> getComponentFromComponents(Class<O> componentType) {
        for (ApplicationComponent<?> component : this.components) {
            if (!componentType.isAssignableFrom(component.getComponentType())) continue;
            return component;
        }
        return null;
    }

    private ListMultimap<MutableInt, ApplicationComponent<?>> computeComponentsReverseOrder() {
        ArrayListMultimap result = ArrayListMultimap.create();
        int round = 0;
        List<ApplicationComponent<?>> componentsSafe = this.components.stream().filter(e -> !e.withDependencies()).collect(Collectors.toCollection(LinkedList::new));
        LinkedHashSet componentsAvailable = new LinkedHashSet();
        this.fillAvailableComponents(componentsAvailable, componentsSafe);
        LinkedList componentsToProcess = new LinkedList(this.components);
        log.info(String.format("Scan for round: %3d - found %d components out of %d", round, componentsSafe.size(), componentsToProcess.size()));
        int roundIndex = 0;
        int roundCount = componentsSafe.size();
        for (ApplicationComponent applicationComponent : componentsSafe) {
            log.info(String.format("Scan for round: %3d (%3d/%3d) - found component %s", round, ++roundIndex, roundCount, applicationComponent));
        }
        componentsToProcess.removeAll(componentsSafe);
        int componentsCount = this.components.size();
        log.info(String.format("Scan for round: %3d - remaining %d components out of %d", round, componentsToProcess.size(), componentsCount));
        result.putAll((Object)new MutableInt(round), (Iterable)componentsSafe);
        do {
            ++round;
            int componentsToProcessCount = componentsToProcess.size();
            componentsSafe = this.processComponents(componentsToProcess, componentsAvailable);
            if (componentsSafe.isEmpty()) {
                if (componentsToProcess.isEmpty()) break;
                throw new IllegalStateException(String.format("Could not find any more components on round %d, with remaining components: %s", round, componentsToProcess));
            }
            log.info(String.format("Scan for round: %3d - found %3d components out of %d", round, componentsSafe.size(), componentsToProcessCount));
            result.putAll((Object)new MutableInt(round), componentsSafe);
            this.fillAvailableComponents(componentsAvailable, componentsSafe);
            int roundIndex2 = 0;
            int n = componentsSafe.size();
            for (ApplicationComponent<?> component : componentsSafe) {
                log.info(String.format("Scan for round: %3d  (%3d/%3d) - found component %s", round, ++roundIndex2, n, component));
            }
            if (componentsToProcess.isEmpty()) continue;
            log.info(String.format("Scan for round: %3d - remaining %3d components out of %d", round, componentsToProcess.size(), componentsCount));
        } while (!componentsToProcess.isEmpty());
        return Multimaps.unmodifiableListMultimap((ListMultimap)result);
    }

    private List<ApplicationComponent<?>> processComponents(List<ApplicationComponent<?>> componentsToProcess, Set<Class<?>> componentsAvailable) {
        LinkedList result = new LinkedList();
        Iterator<ApplicationComponent<?>> iterator = componentsToProcess.iterator();
        while (iterator.hasNext()) {
            ApplicationComponent<?> component = iterator.next();
            List<Class<?>> dependencies = component.getDependencies();
            if (!componentsAvailable.containsAll(dependencies)) continue;
            result.add(component);
            iterator.remove();
        }
        return result;
    }

    private void fillAvailableComponents(Set<Class<?>> componentsAvailable, List<ApplicationComponent<?>> result) {
        for (ApplicationComponent<?> component : result) {
            Set collect = this.componentsCache.entrySet().stream().filter(e -> Objects.equals(component, e.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            componentsAvailable.addAll(collect);
            componentsAvailable.add(component.getComponentType());
        }
    }

    static {
        COMPONENT_SUPPLIERS = new LinkedList();
    }
}

