/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client.v1;

import com.google.gson.GsonBuilder;
import io.ultreia.gc.db.entity.GcCacheCountryStats;
import io.ultreia.gc.db.entity.GcCacheStateStats;
import io.ultreia.gc.db.entity.GcCountry;
import io.ultreia.gc.db.entity.GcDifficulty;
import io.ultreia.gc.db.entity.GcDistrict;
import io.ultreia.gc.db.entity.GcState;
import io.ultreia.gc.db.entity.GcTerrain;
import io.ultreia.gc.model.GcCache;
import io.ultreia.gc.model.GcUser;
import io.ultreia.gc.rest.client.GcRestClientServiceSupport;
import io.ultreia.gc.service.api.GcCacheService;
import io.ultreia.gc.service.api.GcSearchFilter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class GcCacheServiceRestClient
extends GcRestClientServiceSupport
implements GcCacheService {
    public void loadCountryStats(GcCountry country) {
        this.executeRequest(this.forPost("loadCountryStats").addParameter("country", country.compactName()).addAuthToken().setTimeout(TimeUnit.MINUTES, 120).build(), 200);
    }

    public void loadStateStats(GcState state) {
        this.executeRequest(this.forPost("loadStateStats").addParameter("state", state.compactName()).addAuthToken().setTimeout(TimeUnit.MINUTES, 120).build(), 200);
    }

    public void computeCountryStats(GcCountry country, GcDifficulty difficulty, GcTerrain terrain) {
        this.executeRequest(this.forPost("computeCountryStats").addParameter("country", country.compactName()).addParameter("difficulty", (Object)difficulty).addParameter("terrain", (Object)terrain).addAuthToken().setTimeout(TimeUnit.MINUTES, 120).build(), 200);
    }

    public void computeStateStats(GcState state, GcDifficulty difficulty, GcTerrain terrain) {
        this.executeRequest(this.forPost("computeStateStats").addParameter("state", state.compactName()).addParameter("difficulty", (Object)difficulty).addParameter("terrain", (Object)terrain).addAuthToken().setTimeout(TimeUnit.MINUTES, 120).build(), 200);
    }

    public GcCacheStateStats getStateStats(GcState state, boolean reload) {
        return (GcCacheStateStats)this.executeRequest(this.forGet("getStateStats").addParameter("state", state.compactName()).addParameter("reload", (Object)reload).addAuthToken().setTimeout(TimeUnit.MINUTES, 120).build(), 200).toJson(GcCacheStateStats.class);
    }

    public GcCache getCacheFromGcName(String gcName) {
        return (GcCache)this.executeRequest(this.forGet("getCacheFromGcName").addParameter("gcName", gcName).addAuthToken().setTimeout(TimeUnit.MINUTES, 1).build(), 200).toJson(GcCache.class);
    }

    public GcCacheCountryStats getCountryStats(GcCountry country, boolean reload) {
        return (GcCacheCountryStats)this.executeRequest(this.forGet("getCountryStats").addParameter("country", country.compactName()).addParameter("reload", (Object)reload).addAuthToken().setTimeout(TimeUnit.MINUTES, 120).build(), 200).toJson(GcCacheCountryStats.class);
    }

    public Map<String, GcDistrict> acquireDistricts(String geonamesUser) {
        return (Map)this.executeRequest(this.forGet("acquireDistricts").addParameter("geonamesUser", geonamesUser).addAuthToken().setTimeout(TimeUnit.MINUTES, 60).build(), 200).toJson(Map.class);
    }

    public void updateDistrict(String geonamesUser, String gcName) {
        this.executeRequest(this.forPost("updateDistrict").addParameter("geonamesUser", geonamesUser).addParameter("gcName", gcName).addAuthToken().setTimeout(TimeUnit.MINUTES, 60).build(), 200);
    }

    public Set<String> getGcNames() {
        return this.executeRequest(this.forGet("getGcNames").addAuthToken().setTimeout(TimeUnit.MINUTES, 1).build(), 200).toSetOfStrings();
    }

    public Set<String> getGcNamesWithoutLogs() {
        return this.executeRequest(this.forGet("getGcNamesWithoutLogs").addAuthToken().setTimeout(TimeUnit.MINUTES, 1).build(), 200).toSetOfStrings();
    }

    public Set<String> searchCaches(GcSearchFilter filter) {
        return this.executeRequest(this.forGet("searchCaches").addParameter("filter", new GsonBuilder().create().toJson((Object)filter)).addAuthToken().setTimeout(TimeUnit.MINUTES, 1).build(), 200).toSetOfStrings();
    }

    public int searchCachesCount(GcSearchFilter filter) {
        return this.executeRequest(this.forGet("searchCachesCount").addParameter("filter", new GsonBuilder().create().toJson((Object)filter)).addAuthToken().setTimeout(TimeUnit.MINUTES, 1).build(), 200).toInt();
    }

    public void storeCache(GcCache cache) {
        this.executeRequest(this.forPost("storeCache").addParameter("cache", new GsonBuilder().create().toJson((Object)cache)).addAuthToken().setTimeout(TimeUnit.MINUTES, 1).build(), 200);
    }

    public Map<String, Integer> acquireElevations(String geonamesUser) {
        return (Map)this.executeRequest(this.forGet("acquireElevations").addParameter("geonamesUser", geonamesUser).addAuthToken().setTimeout(TimeUnit.MINUTES, 60).build(), 200).toJson(Map.class);
    }

    public void updateElevation(String geonamesUser, String gcName) {
        this.executeRequest(this.forPost("updateElevation").addParameter("geonamesUser", geonamesUser).addParameter("gcName", gcName).addAuthToken().setTimeout(TimeUnit.MINUTES, 60).build(), 200);
    }

    public int updateElevations(String geonamesUser) {
        return this.executeRequest(this.forPost("updateElevations").addParameter("geonamesUser", geonamesUser).addAuthToken().setTimeout(TimeUnit.MINUTES, 60).build(), 200).toInt();
    }

    public int updateDistricts(String geonamesUser) {
        return this.executeRequest(this.forPost("updateDistricts").addParameter("geonamesUser", geonamesUser).addAuthToken().setTimeout(TimeUnit.MINUTES, 60).build(), 200).toInt();
    }

    public void loadFrenchOwnerCachesGcNames(GcUser owner) {
        this.executeRequest(this.forPost("loadFrenchOwnerCachesGcNames").addParameter("owner", new GsonBuilder().create().toJson((Object)owner)).addAuthToken().setTimeout(TimeUnit.MINUTES, 10).build(), 200);
    }
}

