/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client.tool;

import io.ultreia.gc.rest.client.tool.GcRestClientToolSupport;
import io.ultreia.gc.service.api.GcCacheService;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateGcDistricts
extends GcRestClientToolSupport {
    private static final Log log = LogFactory.getLog(UpdateGcDistricts.class);
    private final String[] geonamesUsers = new String[]{"demo", "arktan44", "arktan45", "arktan46", "arktan47", "arktan50", "arktan51", "arktan42", "arktan43", "arktan52", "arktan53", "arktan54", "arktan55", "arktan56", "arktan57", "arktan58", "arktan59"};

    public void run() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                GcCacheService gcCacheService = UpdateGcDistricts.this.applicationContext.newCacheService();
                MutableInt result = new MutableInt();
                for (String geonamesUser : UpdateGcDistricts.this.geonamesUsers) {
                    log.info((Object)("Try this user: " + geonamesUser));
                    try {
                        int updateDistricts = gcCacheService.updateDistricts(geonamesUser);
                        result.add(updateDistricts);
                        log.info((Object)String.format("Update %d district(s) with user: %s", updateDistricts, geonamesUser));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                log.info((Object)String.format("At %s, got %d district(s).", new Date(), result.getValue()));
            }
        };
        new Timer("update-districts").schedule(timerTask, 0L, TimeUnit.MINUTES.toMillis(31L));
    }
}

