/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client.tool;

import io.ultreia.gc.rest.client.tool.GcRestClientToolSupport;
import io.ultreia.gc.service.api.GcCacheService;
import io.ultreia.gc.service.api.GcLogService;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadLogs
extends GcRestClientToolSupport {
    private static final Log log = LogFactory.getLog(LoadLogs.class);

    public void run() {
        MutableInt i = new MutableInt();
        GcCacheService cacheService = this.applicationContext.newCacheService();
        GcLogService logService = this.applicationContext.newLogService();
        LinkedList gcNames = new LinkedList(cacheService.getGcNames());
        gcNames.sort(String::compareTo);
        Collections.reverse(gcNames);
        int size = gcNames.size();
        gcNames.parallelStream().forEach(gcName -> {
            try {
                log.info((Object)String.format("%d/%d : %s", i.incrementAndGet(), size, gcName));
                List logsFromGcName = logService.getLogsFromGcName(gcName, true);
                log.info((Object)String.format("%d/%d : %s - %d", i.getValue(), size, gcName, logsFromGcName.size()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

