/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client.tool;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.ultreia.gc.config.GcApiConfig;
import io.ultreia.gc.model.GcUser;
import io.ultreia.gc.rest.client.tool.GcRestClientToolSupport;
import io.ultreia.gc.rest.client.tool.LoadFrenchOwners;
import io.ultreia.gc.service.api.GcCacheService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadFrenchOwnersCaches
extends GcRestClientToolSupport {
    private static final Log log = LogFactory.getLog(LoadFrenchOwnersCaches.class);

    public void run(boolean reloadUsers) throws IOException {
        Set users;
        Throwable throwable;
        Path path = GcApiConfig.create((String[])new String[0]).getDataDirectory().toPath().resolve("french-owners.json");
        if (Files.exists(path, new LinkOption[0]) && reloadUsers) {
            Files.delete(path);
        }
        if (Files.exists(path, new LinkOption[0])) {
            throwable = null;
            try (BufferedReader reader = Files.newBufferedReader(path);){
                users = (Set)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, new TypeToken<Set<GcUser>>(){}.getType());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        users = new LoadFrenchOwners(this.applicationContext).runAndGet();
        throwable = null;
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)users, (Appendable)writer);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        GcCacheService gcCacheService = this.applicationContext.newCacheService();
        int size = users.size();
        log.info((Object)String.format("Found %s french owner(s).", size));
        MutableInt i = new MutableInt();
        LinkedList badUsers = new LinkedList();
        users.parallelStream().forEach(owner -> {
            String prefix = owner.getUserName();
            log.info((Object)String.format("%S - [%d/%d] Loading caches (count: %d)", prefix, i.incrementAndGet(), size, owner.getCachesOwnedInFrance()));
            try {
                gcCacheService.loadFrenchOwnerCachesGcNames(owner);
            }
            catch (Exception e) {
                log.error((Object)String.format("%S - [%d/%d] Error while loading caches....", prefix, i.getValue(), size));
                badUsers.add(owner);
            }
        });
        if (!badUsers.isEmpty()) {
            badUsers.forEach(b -> log.info((Object)("Could not get caches for user: " + b.getUserName())));
        }
    }
}

