/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client.tool;

import io.ultreia.gc.db.entity.GcCacheCountryStats;
import io.ultreia.gc.db.entity.GcCountry;
import io.ultreia.gc.rest.client.tool.GcRestClientToolSupport;
import io.ultreia.gc.service.api.GcCacheService;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadCountryCaches
extends GcRestClientToolSupport {
    private static final Log log = LogFactory.getLog(LoadCountryCaches.class);

    public void run(String countryStr) throws IOException {
        GcCountry country = GcCountry.of((String)countryStr);
        log.info((Object)String.format("Will load caches for country: %s", country));
        GcCacheService gcCacheService = this.applicationContext.newCacheService();
        GcCacheCountryStats stats = gcCacheService.getCountryStats(country, false);
        log.info((Object)String.format("stats: %d, %d : %d%%", stats.getCurrent(), stats.getTotal(), stats.getCurrent() / stats.getTotal()));
    }
}

