/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client.tool;

import com.google.gson.GsonBuilder;
import io.ultreia.gc.rest.client.GcRestClientConfig;
import io.ultreia.gc.rest.client.tool.GcRestClientToolSupport;
import io.ultreia.gc.service.api.GcCacheService;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AcquireGcDistricts
extends GcRestClientToolSupport {
    private static final Log log = LogFactory.getLog(AcquireGcDistricts.class);
    private final String[] geonamesUsers = new String[]{"demo", "arktan44", "arktan45", "arktan46", "arktan47", "arktan50", "arktan51", "arktan42", "arktan43", "arktan52", "arktan53", "arktan54", "arktan55", "arktan56", "arktan57", "arktan58", "arktan59"};

    public void run() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                GcCacheService gcCacheService = AcquireGcDistricts.this.applicationContext.newCacheService();
                TreeMap result = new TreeMap();
                for (String geonamesUser : AcquireGcDistricts.this.geonamesUsers) {
                    log.info((Object)("Try this user: " + geonamesUser));
                    try {
                        Map updateDistricts = gcCacheService.acquireDistricts(geonamesUser);
                        result.putAll(updateDistricts);
                        log.info((Object)String.format("Update %d district(s) with user: %s", updateDistricts.size(), geonamesUser));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                log.info((Object)String.format("At %s, got %d district(s).", new Date(), result.size()));
                Path district = ((GcRestClientConfig)AcquireGcDistricts.this.applicationContext.getConfig()).getDataDirectory().toPath().resolve("district").resolve(new Date().getTime() + ".json");
                try {
                    if (!Files.exists(district.getParent(), new LinkOption[0])) {
                        Files.createDirectory(district.getParent(), new FileAttribute[0]);
                    }
                    log.info((Object)("Store district to " + district));
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(district, new OpenOption[0]);){
                        new GsonBuilder().setPrettyPrinting().create().toJson(result, (Appendable)bufferedWriter);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        new Timer("update-districts").schedule(timerTask, 0L, TimeUnit.MINUTES.toMillis(3L));
    }
}

