/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client;

import io.ultreia.gc.rest.client.GcRestClientConfigAction;
import io.ultreia.gc.rest.client.GcRestClientConfigOption;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.version.Version;

public abstract class GeneratedGcRestClientConfig
implements Supplier<ApplicationConfig> {
    private ApplicationConfig applicationConfig;

    protected GeneratedGcRestClientConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedGcRestClientConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions((ConfigOptionDef[])GcRestClientConfigOption.values());
        this.applicationConfig.loadActions(GcRestClientConfigAction.class);
    }

    @Override
    public ApplicationConfig get() {
        return this.applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        this.applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public String getConfigFile() {
        return this.applicationConfig.getOption(GcRestClientConfigOption.CONFIG_FILE.getKey());
    }

    public void setConfigFile(String configFile) {
        this.setOption(GcRestClientConfigOption.CONFIG_FILE.getKey(), configFile);
    }

    public Version getBuildVersion() {
        return this.applicationConfig.getOptionAsVersion(GcRestClientConfigOption.BUILD_VERSION.getKey());
    }

    public void setBuildVersion(Version buildVersion) {
        this.setOption(GcRestClientConfigOption.BUILD_VERSION.getKey(), buildVersion);
    }

    public String getBuildDate() {
        return this.applicationConfig.getOption(GcRestClientConfigOption.BUILD_DATE.getKey());
    }

    public void setBuildDate(String buildDate) {
        this.setOption(GcRestClientConfigOption.BUILD_DATE.getKey(), buildDate);
    }

    public String getBuildNumber() {
        return this.applicationConfig.getOption(GcRestClientConfigOption.BUILD_NUMBER.getKey());
    }

    public void setBuildNumber(String buildNumber) {
        this.setOption(GcRestClientConfigOption.BUILD_NUMBER.getKey(), buildNumber);
    }

    public URL getApiUrl() {
        return this.applicationConfig.getOptionAsURL(GcRestClientConfigOption.API_URL.getKey());
    }

    public void setApiUrl(URL apiUrl) {
        this.setOption(GcRestClientConfigOption.API_URL.getKey(), apiUrl);
    }

    public String getClassifier() {
        return this.applicationConfig.getOption(GcRestClientConfigOption.CLASSIFIER.getKey());
    }

    public void setClassifier(String classifier) {
        this.setOption(GcRestClientConfigOption.CLASSIFIER.getKey(), classifier);
    }

    public File getDataDirectory() {
        return this.applicationConfig.getOptionAsFile(GcRestClientConfigOption.DATA_DIRECTORY.getKey());
    }

    public void setDataDirectory(File dataDirectory) {
        this.setOption(GcRestClientConfigOption.DATA_DIRECTORY.getKey(), dataDirectory);
    }

    public File getTemporaryDirectory() {
        return this.applicationConfig.getOptionAsFile(GcRestClientConfigOption.TEMPORARY_DIRECTORY.getKey());
    }

    public void setTemporaryDirectory(File temporaryDirectory) {
        this.setOption(GcRestClientConfigOption.TEMPORARY_DIRECTORY.getKey(), temporaryDirectory);
    }

    public String getLogin() {
        return this.applicationConfig.getOption(GcRestClientConfigOption.LOGIN.getKey());
    }

    public void setLogin(String login) {
        this.setOption(GcRestClientConfigOption.LOGIN.getKey(), login);
    }

    public String getPassword() {
        return this.applicationConfig.getOption(GcRestClientConfigOption.PASSWORD.getKey());
    }

    public void setPassword(String password) {
        this.setOption(GcRestClientConfigOption.PASSWORD.getKey(), password);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", this.get().getConfigFileName()));
        for (GcRestClientConfigOption option : this.orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), this.get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<GcRestClientConfigOption> orderedByKey() {
        List<GcRestClientConfigOption> values = Arrays.asList(GcRestClientConfigOption.values());
        Collections.sort(values, new Comparator<GcRestClientConfigOption>(){

            @Override
            public int compare(GcRestClientConfigOption o1, GcRestClientConfigOption o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(values);
    }
}

