/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.gc.rest.client;

import io.ultreia.gc.http.GcRequest;
import io.ultreia.gc.http.GcRequestBuilder;
import io.ultreia.gc.http.GcResponse;
import io.ultreia.gc.rest.client.GcRestClientApplicationContext;
import io.ultreia.gc.rest.client.GcRestClientConfig;
import io.ultreia.gc.service.api.GcServiceContext;
import io.ultreia.gc.service.api.GcServiceSupport;
import java.util.concurrent.TimeUnit;

public abstract class GcRestClientServiceSupport
extends GcServiceSupport {
    private String apiUrl;

    public void setServiceContext(GcServiceContext serviceContext) {
        super.setServiceContext(serviceContext);
        GcRestClientConfig config = (GcRestClientConfig)this.getServiceContext().getConfig();
        this.apiUrl = config.getApiUrl().toExternalForm();
        if (!this.apiUrl.endsWith("/")) {
            this.apiUrl = this.apiUrl + "/";
        }
    }

    public GcRestClientApplicationContext getServiceContext() {
        return (GcRestClientApplicationContext)super.getServiceContext();
    }

    protected GcRequestBuilder forGet(String baseUrl) {
        GcRequestBuilder requestBuilder = GcRequestBuilder.forGet((String)(this.apiUrl + baseUrl), this::getAuthenticationToken);
        this.addAuthId(requestBuilder);
        return requestBuilder.setTimeout(TimeUnit.HOURS, 1);
    }

    protected GcRequestBuilder forPost(String baseUrl) {
        GcRequestBuilder requestBuilder = GcRequestBuilder.forPost((String)(this.apiUrl + baseUrl), this::getAuthenticationToken);
        this.addAuthId(requestBuilder);
        return requestBuilder.setTimeout(TimeUnit.HOURS, 1);
    }

    protected GcRequestBuilder forDelete(String baseUrl) {
        GcRequestBuilder requestBuilder = GcRequestBuilder.forDelete((String)(this.apiUrl + baseUrl), this::getAuthenticationToken);
        this.addAuthId(requestBuilder);
        return requestBuilder.setTimeout(TimeUnit.HOURS, 1);
    }

    protected GcResponse executeRequest(GcRequest request) {
        return this.getServiceContext().executeRequest(request);
    }

    protected GcResponse executeRequest(GcRequest request, int expectedStatusCode) {
        return this.getServiceContext().executeRequest(request, expectedStatusCode);
    }

    private void addAuthId(GcRequestBuilder requestBuilder) {
        if (this.getServiceContext().withAuthId()) {
            requestBuilder.addAuthToken();
        }
    }

    private String getAuthenticationToken() {
        return this.getServiceContext().getAuthId().orElse(null);
    }
}

